/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.application;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.contrib.MiniMapView;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.standard.NullDrawingView;
import org.jhotdraw.standard.NullTool;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.PaletteButton;
import org.jhotdraw.util.PaletteListener;
import org.jhotdraw.util.UndoManager;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.musoft.limo.application.AboutDialog;
import org.musoft.limo.application.ApplicationListener;
import org.musoft.limo.application.ControlPane;
import org.musoft.limo.application.MainPane;
import org.musoft.limo.application.MenuBar;
import org.musoft.limo.application.MyToolButton;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.StatusBar;
import org.musoft.limo.application.ToolBar;
import org.musoft.limo.drawing.DrawingPanel;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelDrawingView;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.hypertext.HypertextEditor;
import org.musoft.limo.hypertext.HypertextViewer;
import org.musoft.limo.inspector.NoticeEditor;
import org.musoft.limo.inspector.PropertyPanel;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAdapter;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelEnumeration;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelLoader;
import org.musoft.limo.model.ModelSaver;
import org.musoft.limo.navigator.RessourceTree;
import org.musoft.limo.print.Printer;
import org.musoft.limo.print.PrinterSource;
import org.musoft.limo.quickview.ResourceQuickView;
import org.musoft.limo.util.ComponentPane;
import org.musoft.limo.util.LogFile;
import org.musoft.limo.util.Preferences;
import org.musoft.limo.util.SimpleFileFilter;
import org.musoft.limo.util.Themer;

public abstract class Application
extends JFrame
implements DrawingEditor,
PaletteListener,
ComponentListener,
PropertyChangeListener {
    public HypertextViewer help = null;
    public static final int EDITOR = 0;
    public static final int VIEWER = 1;
    public static final int FULLSCREEN = 2;
    private Tool currentTool;
    protected ToolBar toolbar;
    private StatusBar statusbar;
    private JSplitPane leftSplitPane;
    private JSplitPane rightSplitPane;
    private int leftSplitPos;
    private int rightSplitPos;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private MyToolButton fDefaultToolButton;
    private MyToolButton fSelectedToolButton;
    private UndoManager myUndoManager;
    private final EventListenerList listenerList = new EventListenerList();
    protected Model currentModel;
    private JTabbedPane drawingpane;
    protected ControlPane controlPane;
    private ComponentPane hypertextpane;
    private MenuBar menubar;
    protected MainPane mainpane;
    private String loadedModelFilename;
    private Iconkit fIconkit;
    private int viewMode = 1;
    private int previousViewMode = 1;
    private boolean modelEditable = true;
    int savedState = 0;
    private boolean doMaximize = false;
    private boolean firstStart = false;
    private DrawingPanel activeDrawingPanel;
    private Vector listeners = new Vector();
    protected PropertyPanel inspector;
    protected RessourceTree navigator;
    protected NoticeEditor notepad;
    protected ResourceQuickView birdsEye;
    protected HypertextEditor hypertextEditor;
    protected HypertextViewer hypertextViewer;
    public static final int PANE_RIGHT = 1;
    public static final int PANE_CENTER = 2;
    public static final int PANE_LEFT_TOP = 4;
    public static final int PANE_LEFT_BOTTOM = 8;
    private Printer printer;
    private Hashtable componentsPanes = new Hashtable();
    private Point oldWantedPos = new Point(-100, -100);
    private Point oldScrollPos = new Point(-100, -100);
    private Preferences preferences = new Preferences();
    private String osName = System.getProperty("os.name");
    private final String PREF_LASTPRINTER = "LastPrinter";
    private final String PREF_WINDOW = "Window";
    private final String PREF_WINDOW_X = "WindowXCoord";
    private final String PREF_WINDOW_Y = "WindowYCoord";
    private final String PREF_WINDOW_HEIGHT = "WindowHeight";
    private final String PREF_WINDOW_WIDTH = "WindowWidth";
    private final String PREF_WINDOW_STATE = "WindowState";
    private final String PREF_LEFTSPLIT = "LeftSplit";
    private final String PREF_RIGHTSPLIT = "RightSplit";
    private final String PREF_LASTLEFTSPLIT = "LastLeftSplit";
    private final String PREF_LASTRIGHTSPLIT = "LastRightSplit";
    private final String PREF_CONTROLSPLIT = "ControlSplit";
    private final String PREF_DIRS_AND_FILES = "DirsAndFiles";
    private final String PREF_CURRENTDIR = "CurrentDir";
    private final String PREF_RECENTFILE = "RecentFile";
    private final String PREF_LOOKANDFEEL = "LookAndFeel";
    private final String PREF_METALTHEME = "MetalTheme";
    private Vector recentFiles;
    static /* synthetic */ Class class$org$jhotdraw$framework$ViewChangeListener;
    static /* synthetic */ Class class$org$musoft$limo$model$Model;
    static /* synthetic */ Class class$org$musoft$limo$drawing$DrawingPanel;
    static /* synthetic */ Class class$org$jhotdraw$framework$DrawingView;

    public Application() {
        super(Resource.getString("APP_TITLE"));
        this.createLogger();
        LogFile.log("----- " + this.getApplicationTitle() + " Version " + this.getApplicationVersion() + " started. -----");
        this.recentFiles = new Vector();
        this.fIconkit = new Iconkit((Component)this);
        this.setIconImage(this.fIconkit.loadImageResource(Resource.getString("TITLE_ICON")));
        this.setUndoManager(new UndoManager());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Application.this.exit();
            }
        });
        this.createComponents();
        this.createUI();
        this.loadParams();
        this.setDefaultLayout();
        this.setTool((Tool)new NullTool((DrawingEditor)this), "");
        this.toolDone();
        this.checkToolsAndMenus();
        if (this.doMaximize) {
            this.setBounds(0, 0, 800, 600);
            this.setVisible(true);
            this.setExtendedState(6);
        } else {
            this.setVisible(true);
        }
        if (this.firstStart) {
            this.showHelp();
        }
        this.printer = new Printer(this);
    }

    protected void setDefaultLayout() {
        Dimension dimension = new Dimension(800, 600);
        if (this.getWidth() < dimension.width) {
            this.setSize(dimension.width, dimension.height);
        }
        this.showComponentInTab(this.navigator, 4, true);
        this.showComponentInTab(this.birdsEye, 4, false);
        this.showComponentInTab(this.inspector, 8, true);
        this.showComponentInTab(this.notepad, 8, false);
        this.showComponentInTab(this.hypertextEditor, 1, true);
        this.showComponentInTab(this.hypertextViewer, 1, false);
    }

    protected void createComponents() {
        this.navigator = new RessourceTree(this);
        this.birdsEye = new ResourceQuickView(this);
        this.inspector = new PropertyPanel(this);
        this.notepad = new NoticeEditor(this);
        this.hypertextEditor = new HypertextEditor(this);
        this.hypertextViewer = new HypertextViewer(this, Resource.getString("COMP_HTMLVIEWER"));
    }

    private void createUI() {
        this.mainpane = new MainPane(this);
        this.mainpane.setDrawingView(this.createInitialDrawingView());
        this.controlPane = new ControlPane(this);
        this.hypertextpane = new ComponentPane();
        this.statusbar = new StatusBar(this);
        this.toolbar = this.createToolBar();
        this.mainpane.setMinimumSize(new Dimension(0, 0));
        this.mainpane.setMaximumSize(new Dimension(1024, 768));
        this.controlPane.setMinimumSize(new Dimension(0, 0));
        this.controlPane.setMaximumSize(new Dimension(1024, 768));
        this.hypertextpane.setMinimumSize(new Dimension(0, 0));
        this.hypertextpane.setMaximumSize(new Dimension(1024, 768));
        this.rightSplitPane = new JSplitPane(1, this.mainpane, this.hypertextpane);
        this.rightSplitPane.setOneTouchExpandable(true);
        this.rightSplitPane.setDividerLocation(350);
        this.rightSplitPane.setLastDividerLocation(350);
        this.rightSplitPos = 350;
        this.rightSplitPane.setResizeWeight(1.0);
        this.rightSplitPane.addPropertyChangeListener("dividerLocation", this);
        this.leftSplitPane = new JSplitPane(1, this.controlPane, this.rightSplitPane);
        this.leftSplitPane.setOneTouchExpandable(true);
        this.leftSplitPane.setDividerLocation(200);
        this.leftSplitPane.setLastDividerLocation(200);
        this.leftSplitPos = 200;
        this.leftSplitPane.setResizeWeight(0.0);
        this.leftSplitPane.addPropertyChangeListener("dividerLocation", this);
        this.setMenuBar(this.createMenuBar());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.statusbar, "South");
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.leftSplitPane, "Center");
    }

    protected abstract Model createModel();

    protected abstract ToolBar createToolBar();

    protected abstract MenuBar createMenuBar();

    private void setMenuBar(MenuBar menuBar) {
        this.setJMenuBar(menuBar);
        this.menubar = menuBar;
        if (this.getWidth() < menuBar.getPreferredSize().width) {
            this.setSize(menuBar.getPreferredSize().width, this.getHeight());
        }
    }

    public MainPane getMainPane() {
        return this.mainpane;
    }

    public void showLeftPane(boolean bl) {
        if (bl) {
            this.leftSplitPane.setDividerLocation(this.leftSplitPos);
        } else {
            this.leftSplitPane.removePropertyChangeListener("dividerLocation", this);
            this.minimizeSplitPane(this.leftSplitPane, 0);
            this.leftSplitPane.addPropertyChangeListener("dividerLocation", this);
        }
    }

    public void showRightPane(boolean bl) {
        if (bl) {
            this.rightSplitPane.setDividerLocation(this.rightSplitPos);
        } else {
            this.rightSplitPane.removePropertyChangeListener("dividerLocation", this);
            this.minimizeSplitPane(this.rightSplitPane, 1);
            this.rightSplitPane.addPropertyChangeListener("dividerLocation", this);
        }
    }

    private void minimizeSplitPane(JSplitPane jSplitPane, int n) {
        int n2 = jSplitPane.getDividerLocation();
        int n3 = jSplitPane.getDividerLocation();
        int n4 = n2;
        if (jSplitPane.getOrientation() == 1) {
            n4 = n == 0 ? 0 : this.getBounds().width;
        }
        jSplitPane.setDividerLocation(n4);
        jSplitPane.setLastDividerLocation(n3);
    }

    protected void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Application.this.exit();
            }
        });
    }

    protected DrawingView createDrawingView(Model model) {
        boolean bl = this.currentModel.getDirty();
        ModelDrawingView modelDrawingView = new ModelDrawingView(this);
        modelDrawingView.setDrawing(this.createDrawing(model));
        modelDrawingView.setBackground(Color.white);
        this.fireViewCreatedEvent((DrawingView)modelDrawingView);
        this.currentModel.setDirty(bl);
        return modelDrawingView;
    }

    protected Dimension getDrawingViewSize() {
        return this.getDrawingView().getSize();
    }

    protected Drawing createDrawing(Model model) {
        if (model == null) {
            LogFile.log("Warnung: model=null in createDrawing()", LogFile.WARNING);
        }
        return new ModelDrawing(model);
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        MyToolButton myToolButton = (MyToolButton)paletteButton;
        this.setTool(myToolButton.tool(), myToolButton.name());
        this.setSelected(myToolButton);
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean bl) {
    }

    public Tool tool() {
        return this.currentTool;
    }

    public DrawingView view() {
        return this.getDrawingView();
    }

    public void setDefaultToolButton(MyToolButton myToolButton) {
        this.fDefaultToolButton = myToolButton;
    }

    public void selectDefaultTool() {
        if (this.fDefaultToolButton != null) {
            this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
            this.setSelected(this.fDefaultToolButton);
        }
    }

    public void toolDone() {
        if (!(this.fSelectedToolButton instanceof MyToolButton && this.fSelectedToolButton.isPermanent() || this.fDefaultToolButton == null)) {
            this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
            this.setSelected(this.fDefaultToolButton);
        }
    }

    public void figureSelectionChanged(DrawingView drawingView) {
        int n;
        ModelElement[] modelElementArray;
        if (drawingView.selectionCount() != 1) {
            // empty if block
        }
        Vector<ModelElement> vector = new Vector<ModelElement>();
        FigureEnumeration figureEnumeration = drawingView.selection();
        while (figureEnumeration.hasNextFigure()) {
            modelElementArray = figureEnumeration.nextFigure();
            if (modelElementArray instanceof ModelFigure) {
                vector.addElement(((ModelFigure)modelElementArray).getElement());
                continue;
            }
            if (modelElementArray instanceof ModelConnection) {
                vector.addElement(((ModelConnection)modelElementArray).getElement());
                continue;
            }
            if (!(modelElementArray instanceof ModelConnection.Label)) continue;
            vector.addElement(((ModelConnection.Label)modelElementArray).getFigure().getElement());
        }
        modelElementArray = new ModelElement[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            modelElementArray[n] = (ModelElement)vector.elementAt(n);
        }
        for (n = 0; n < this.getListenerCount(); ++n) {
            this.getListener(n).onModelSelectionChanged(this, this.getCurrentRoot(), modelElementArray);
        }
    }

    public void addViewChangeListener(ViewChangeListener viewChangeListener) {
        this.listenerList.add(class$org$jhotdraw$framework$ViewChangeListener == null ? (class$org$jhotdraw$framework$ViewChangeListener = Application.class$("org.jhotdraw.framework.ViewChangeListener")) : class$org$jhotdraw$framework$ViewChangeListener, viewChangeListener);
    }

    public void removeViewChangeListener(ViewChangeListener viewChangeListener) {
        this.listenerList.remove(class$org$jhotdraw$framework$ViewChangeListener == null ? (class$org$jhotdraw$framework$ViewChangeListener = Application.class$("org.jhotdraw.framework.ViewChangeListener")) : class$org$jhotdraw$framework$ViewChangeListener, viewChangeListener);
    }

    protected void fireViewSelectionChangedEvent(DrawingView drawingView, DrawingView drawingView2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ViewChangeListener viewChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jhotdraw$framework$ViewChangeListener == null ? Application.class$("org.jhotdraw.framework.ViewChangeListener") : class$org$jhotdraw$framework$ViewChangeListener)) continue;
            viewChangeListener = (ViewChangeListener)objectArray[i + 1];
            viewChangeListener.viewSelectionChanged(drawingView, drawingView2);
        }
    }

    protected void fireViewCreatedEvent(DrawingView drawingView) {
        Object[] objectArray = this.listenerList.getListenerList();
        ViewChangeListener viewChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jhotdraw$framework$ViewChangeListener == null ? Application.class$("org.jhotdraw.framework.ViewChangeListener") : class$org$jhotdraw$framework$ViewChangeListener)) continue;
            viewChangeListener = (ViewChangeListener)objectArray[i + 1];
            viewChangeListener.viewCreated(drawingView);
        }
    }

    protected void fireViewDestroyingEvent(DrawingView drawingView) {
        Object[] objectArray = this.listenerList.getListenerList();
        ViewChangeListener viewChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jhotdraw$framework$ViewChangeListener == null ? Application.class$("org.jhotdraw.framework.ViewChangeListener") : class$org$jhotdraw$framework$ViewChangeListener)) continue;
            viewChangeListener = (ViewChangeListener)objectArray[i + 1];
            viewChangeListener.viewDestroying(drawingView);
        }
    }

    public void showStatus(String string) {
        if (string != null) {
            this.statusbar.setText(string);
        } else {
            this.statusbar.setText(" ");
        }
        this.repaint();
    }

    public void setTool(Tool tool, String string) {
        if (this.tool() != null && this.tool().isActive()) {
            this.tool().deactivate();
        }
        this.currentTool = tool;
        if (this.tool() != null) {
            this.showStatus(string);
            this.tool().activate();
        }
    }

    private void setSelected(MyToolButton myToolButton) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = myToolButton;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    public void exit() {
        this.toolDone();
        if (!this.promptClose()) {
            return;
        }
        this.saveParams();
        this.setVisible(false);
        this.dispose();
        LogFile.log("----- " + this.getApplicationTitle() + " Version " + this.getApplicationVersion() + " exited. -----");
        System.exit(0);
    }

    public void promptOpen(String string) {
        this.toolDone();
        if (this.currentModel != null && !this.promptClose()) {
            return;
        }
        try {
            this.modelEditable = new File(string).canWrite();
            this.setViewMode(this.modelEditable ? 0 : 1);
            this.loadModel(string);
            this.setCurrentProjectDir(new File(string).getParent());
            this.currentModel.setDirty(false);
            for (int i = 0; i < this.getListenerCount(); ++i) {
                this.getListener(i).onModelLoaded(this, this.currentModel);
            }
            this.showStatus(Resource.getString("TXT_PROJECT") + " '" + string + "' " + Resource.getString("TXT_WASLOADED"));
        }
        catch (Exception exception) {
            LogFile.log(exception);
            this.showStatus(Resource.getString("TXT_ERRORWHILELOADING") + " '" + string + "'!");
        }
    }

    public void promptOpen() {
        this.toolDone();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Resource.getString("DLG_FILEOPEN"));
        jFileChooser.setFileFilter(new SimpleFileFilter(Resource.getString("FILE_EXTENSION_XML"), Resource.getString("FILE_DESCRIPTION_XML")));
        if (this.getCurrentProjectDir() != null) {
            jFileChooser.setCurrentDirectory(new File(this.getCurrentProjectDir()));
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            if (this.currentModel != null && !this.promptClose()) {
                return;
            }
            this.showStatus(Resource.getString("TXT_PROJECT") + " '" + jFileChooser.getSelectedFile() + "' " + Resource.getString("TXT_LOADING"));
            this.promptOpen(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        this.checkToolsAndMenus();
    }

    public void saveModel() {
        if (this.loadedModelFilename == null) {
            this.promptSaveAs();
        } else {
            try {
                new ModelSaver(this.currentModel).save(this.loadedModelFilename);
                this.currentModel.setDirty(false);
                for (int i = 0; i < this.getListenerCount(); ++i) {
                    this.getListener(i).onModelSaved(this, this.currentModel);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void promptSaveAs() {
        JFileChooser jFileChooser;
        block8: {
            this.toolDone();
            jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(Resource.getString("DLG_FILESAVE"));
            jFileChooser.setFileFilter(new SimpleFileFilter(Resource.getString("FILE_EXTENSION_XML"), Resource.getString("FILE_DESCRIPTION_XML")));
            if (this.getCurrentProjectDir() != null) {
                jFileChooser.setCurrentDirectory(new File(this.getCurrentProjectDir()));
            }
            while (jFileChooser.showSaveDialog(this) == 0) {
                if (jFileChooser.getSelectedFile().exists()) {
                    int n = JOptionPane.showConfirmDialog(this, Resource.getString("QUEST_OVERWRITE"), Resource.getString("DLG_CONFIRM"), 1);
                    if (n == 2) {
                        return;
                    }
                    if (n != 0) continue;
                }
                break block8;
            }
            return;
        }
        try {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.setCurrentProjectDir(jFileChooser.getCurrentDirectory().getAbsolutePath());
            if (!string.endsWith(Resource.getString("FILE_EXTENSION_XML"))) {
                string = string + "." + Resource.getString("FILE_EXTENSION_XML");
            }
            this.loadedModelFilename = string;
            new ModelSaver(this.currentModel).save(string);
            this.addToRescentFiles(string);
            this.currentModel.setDirty(false);
            for (int i = 0; i < this.getListenerCount(); ++i) {
                this.getListener(i).onModelSaved(this, this.currentModel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.checkToolsAndMenus();
    }

    public boolean promptClose() {
        int n;
        this.toolDone();
        if (this.currentModel == null) {
            this.showStatus(Resource.getString("TXT_NOPROJECT"));
            return true;
        }
        if (this.currentModel.getDirty()) {
            n = JOptionPane.showConfirmDialog(this, Resource.getString("QUEST_SAVECLOSE"), Resource.getString("TXT_CLOSE"), 1);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                this.saveModel();
            }
        }
        this.loadedModelFilename = null;
        if (this.mainpane.getShowDrawingView()) {
            this.mainpane.removeAll();
        }
        this.fireViewDestroyingEvent(this.getDrawingView());
        this.mainpane.setDrawingView(NullDrawingView.getManagedDrawingView((DrawingEditor)this));
        for (n = 0; n < this.getListenerCount(); ++n) {
            this.getListener(n).onModelDestroying(this, this.currentModel);
        }
        this.currentModel.destroy();
        this.currentModel = null;
        this.repaint();
        this.checkToolsAndMenus();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void promptPrint(boolean bl) {
        PrinterSource[] printerSourceArray = this.getPrintablePanels();
        boolean[] blArray = this.getPrintableSelection(printerSourceArray);
        this.printer.startJob(printerSourceArray, blArray);
        try {
            if (bl) {
                if (this.printer.showSelectionDialog() && this.printer.showPrinterDialog()) {
                    this.printer.print();
                }
            } else {
                this.printer.print();
            }
            Object var5_4 = null;
            this.printer.endJob();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.printer.endJob();
            for (int i = 0; i < printerSourceArray.length; ++i) {
                DrawingPanel drawingPanel;
                if (!(printerSourceArray[i] instanceof DrawingPanel) || (drawingPanel = (DrawingPanel)printerSourceArray[i]).getParent() != null || !(drawingPanel.getDrawing() instanceof ModelDrawing)) continue;
                ModelDrawing modelDrawing = (ModelDrawing)drawingPanel.getDrawing();
                modelDrawing.destroy();
                modelDrawing.release();
                printerSourceArray[i] = null;
            }
            throw throwable;
        }
        for (int i = 0; i < printerSourceArray.length; ++i) {
            DrawingPanel drawingPanel;
            if (!(printerSourceArray[i] instanceof DrawingPanel) || (drawingPanel = (DrawingPanel)printerSourceArray[i]).getParent() != null || !(drawingPanel.getDrawing() instanceof ModelDrawing)) continue;
            ModelDrawing modelDrawing = (ModelDrawing)drawingPanel.getDrawing();
            modelDrawing.destroy();
            modelDrawing.release();
            printerSourceArray[i] = null;
        }
    }

    public PrinterSource[] getPrintablePanels() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        ModelEnumeration modelEnumeration = this.getModel().getChildren(class$org$musoft$limo$model$Model == null ? (class$org$musoft$limo$model$Model = Application.class$("org.musoft.limo.model.Model")) : class$org$musoft$limo$model$Model, true);
        while (modelEnumeration.hasMoreElements()) {
            object = (Model)modelEnumeration.nextModelElement();
            DrawingPanel drawingPanel = new DrawingPanel(this.createDrawingView((Model)object));
            vector.add(drawingPanel);
            vector2.add(object);
        }
        object = new DrawingPanel(this.createDrawingView(this.getModel()));
        vector.add(object);
        vector2.add(this.getModel());
        for (int i = 0; i < this.getMainPane().getComponentCount(); ++i) {
            Component component = this.getMainPane().getComponentAt(i);
            if (component instanceof DrawingPanel) {
                if (!(((DrawingPanel)component).getDrawing() instanceof ModelDrawing)) continue;
                Model model = ((ModelDrawing)((DrawingPanel)component).getDrawing()).getModel();
                if (vector2.contains(((ModelDrawing)((DrawingPanel)component).getDrawing()).getModel())) continue;
                vector.add(component);
                continue;
            }
            if (!(component instanceof PrinterSource)) continue;
            vector.add(component);
        }
        return vector.toArray(new PrinterSource[0]);
    }

    protected boolean[] getPrintableSelection(PrinterSource[] printerSourceArray) {
        DrawingPanel drawingPanel;
        boolean[] blArray = new boolean[printerSourceArray.length];
        int n = -1;
        if (this.mainpane.getSelectedComponent() instanceof DrawingPanel && (drawingPanel = (DrawingPanel)this.mainpane.getSelectedComponent()).getDrawing() instanceof ModelDrawing) {
            Model model = ((ModelDrawing)drawingPanel.getDrawing()).getModel();
            for (int i = 0; i < printerSourceArray.length; ++i) {
                Model model2;
                DrawingPanel drawingPanel2;
                if (!(printerSourceArray[i] instanceof DrawingPanel) || (drawingPanel2 = (DrawingPanel)printerSourceArray[i]).getParent() != null || !(drawingPanel2.getDrawing() instanceof ModelDrawing) || (model2 = ((ModelDrawing)drawingPanel2.getDrawing()).getModel()) != model) continue;
                n = i;
                break;
            }
        }
        if (n == -1) {
            for (int i = 0; i < printerSourceArray.length; ++i) {
                if (printerSourceArray[i] != this.mainpane.getSelectedComponent()) continue;
                n = i;
                break;
            }
        }
        if (n != -1) {
            blArray[n] = true;
        }
        return blArray;
    }

    protected void setupExportDialog(JFileChooser jFileChooser) {
        jFileChooser.setDialogTitle(Resource.getString("DLG_EXPORT"));
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter("eps", "Encapsulated Postscript");
        jFileChooser.addChoosableFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter("jpg", "Joint Photographic Experts Group");
        jFileChooser.addChoosableFileFilter(simpleFileFilter);
        simpleFileFilter = new SimpleFileFilter("png", "Portable Network Graphics");
        jFileChooser.addChoosableFileFilter(simpleFileFilter);
    }

    protected void export(String string) throws IOException {
        PrinterSource printerSource = (PrinterSource)((Object)this.mainpane.getCurrentPanel());
        Rectangle rectangle = printerSource.getPrintBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width + 20, rectangle.height + 20, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.translate(-rectangle.x + 10, -rectangle.y + 10);
        printerSource.doPrintComponent(graphics2D);
        if (string.endsWith(Resource.getString("png"))) {
            File file = new File(string);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        } else if (string.endsWith(Resource.getString("jpg"))) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            jPEGImageEncoder.encode(bufferedImage);
            ((OutputStream)fileOutputStream).close();
        } else if (string.endsWith(Resource.getString("eps"))) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            EpsGraphics2D epsGraphics2D = new EpsGraphics2D(string, fileOutputStream, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            epsGraphics2D.drawImage(bufferedImage, new AffineTransformOp(new AffineTransform(), 2), 0, 0);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    public void promptExport() {
        this.tool().deactivate();
        if (!(this.mainpane.getCurrentPanel() instanceof PrinterSource)) {
            this.showStatus(Resource.getString("TXT_NOTHIG_TO_EXPORT"));
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        this.setupExportDialog(jFileChooser);
        if (this.getCurrentProjectDir() != null) {
            jFileChooser.setCurrentDirectory(new File(this.getCurrentProjectDir()));
        }
        if (jFileChooser.showSaveDialog(this) == 0) {
            try {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                FileFilter fileFilter = jFileChooser.getFileFilter();
                if (fileFilter instanceof SimpleFileFilter) {
                    String string2 = ((SimpleFileFilter)fileFilter).getExtension();
                    if (!string.toLowerCase().endsWith(string2)) {
                        string = string + string2;
                    }
                } else if (!string.toLowerCase().endsWith(".png")) {
                    string = string + ".png";
                }
                this.export(string);
                this.setCurrentProjectDir(jFileChooser.getCurrentDirectory().getAbsolutePath());
            }
            catch (Exception exception) {
                LogFile.log(exception);
            }
        }
        this.tool().activate();
    }

    public void loadModel(String string) {
        ModelLoader modelLoader = new ModelLoader(this.getModelClassPrefix());
        try {
            this.currentModel = modelLoader.load(string);
            this.loadedModelFilename = string;
        }
        catch (Exception exception) {
            this.loadedModelFilename = null;
            exception.printStackTrace();
        }
        this.newWindow(this.currentModel);
        this.addToRescentFiles(string);
    }

    protected void setUndoManager(UndoManager undoManager) {
        this.myUndoManager = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }

    public void promptNew() {
        if (this.currentModel != null && !this.promptClose()) {
            return;
        }
        this.loadedModelFilename = null;
        this.currentModel = this.createModel();
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onModelCreated(this, this.currentModel);
        }
        this.newWindow(this.currentModel);
        this.modelEditable = true;
        this.setViewMode(this.modelEditable ? 0 : 1);
        this.checkToolsAndMenus();
        if (this.currentModel != null) {
            this.currentModel.setDirty(false);
        }
    }

    public void newWindow(Model model) {
        boolean bl = this.currentModel.getDirty();
        DrawingView drawingView = this.createDrawingView(model);
        for (int i = 0; i < this.mainpane.getComponentCount(); ++i) {
            if (!(this.mainpane.getComponentAt(i) instanceof DrawingPanel) || ((ModelDrawing)((DrawingPanel)this.mainpane.getComponentAt(i)).getDrawing()).getModel() != model) continue;
            this.mainpane.setSelectedIndex(i);
            return;
        }
        this.activeDrawingPanel = this.mainpane.createDrawingViewTab(drawingView);
        this.toolDone();
        this.currentModel.addListener(new ModelAdapter(){

            public void onSetDirty() {
                Application.this.checkToolsAndMenus();
            }

            public void onSetName(ModelElement modelElement) {
                if (modelElement == Application.this.currentModel) {
                    Application.this.mainpane.renameTab(Application.this.activeDrawingPanel, Application.this.getCurrentTabTitle(Application.this.activeDrawingPanel.getDrawingView()));
                }
            }
        });
        this.currentModel.setDirty(bl);
    }

    protected DrawingView createInitialDrawingView() {
        return NullDrawingView.getManagedDrawingView((DrawingEditor)this);
    }

    public void activatePanel(JPanel jPanel) {
        if (jPanel instanceof DrawingPanel) {
            ModelDrawing modelDrawing;
            if (this.mainpane.getCurrentPanel() != jPanel) {
                if (((DrawingPanel)jPanel).getDrawingView().drawing() != null) {
                    ((DrawingPanel)jPanel).getDrawingView().unfreezeView();
                }
                if (this.mainpane.getCurrentPanel() != null) {
                    ((DrawingPanel)this.mainpane.getCurrentPanel()).getDrawingView().freezeView();
                    ((DrawingPanel)this.mainpane.getCurrentPanel()).getDrawingView().clearSelection();
                }
            }
            this.mainpane.setDrawingView(((DrawingPanel)jPanel).getDrawingView());
            Drawing drawing = ((DrawingPanel)jPanel).getDrawing();
            if (drawing instanceof ModelDrawing) {
                modelDrawing = (ModelDrawing)drawing;
                Model model = modelDrawing.getModel();
                this.fireModelSelectionChanged(new ModelElement[]{model});
            }
            modelDrawing = new MiniMapView(((DrawingPanel)jPanel).getDrawingView(), ((DrawingPanel)jPanel).getScrollpane());
            this.birdsEye.setMinimap((MiniMapView)modelDrawing);
        }
    }

    protected String getCurrentTabTitle(DrawingView drawingView) {
        return ((ModelDrawing)drawingView.drawing()).getModel().getName() + " - " + Resource.getString("DRAWING_PREFIX");
    }

    protected String getCurrentTabTitleTooltip(DrawingView drawingView) {
        return ((ModelDrawing)drawingView.drawing()).getModel().getFullName();
    }

    public void deactivatePanel(JPanel jPanel) {
    }

    public DrawingView[] views() {
        ArrayList<DrawingView> arrayList = new ArrayList<DrawingView>();
        for (int i = 0; i < this.mainpane.getTabCount(); ++i) {
            DrawingView drawingView;
            if (!(class$org$musoft$limo$drawing$DrawingPanel == null ? Application.class$("org.musoft.limo.drawing.DrawingPanel") : class$org$musoft$limo$drawing$DrawingPanel).isInstance(this.mainpane.getComponent(i)) || !(class$org$jhotdraw$framework$DrawingView == null ? Application.class$("org.jhotdraw.framework.DrawingView") : class$org$jhotdraw$framework$DrawingView).isInstance(drawingView = ((DrawingPanel)this.mainpane.getComponent(i)).getDrawingView())) continue;
            arrayList.add(drawingView);
        }
        DrawingView[] drawingViewArray = new DrawingView[arrayList.size()];
        arrayList.toArray(drawingViewArray);
        return drawingViewArray;
    }

    public Model getCurrentRoot() {
        if (this.mainpane.getCurrentPanel() instanceof DrawingPanel && ((DrawingPanel)this.mainpane.getCurrentPanel()).getDrawingView().drawing() instanceof ModelDrawing) {
            return ((ModelDrawing)((DrawingPanel)this.mainpane.getCurrentPanel()).getDrawingView().drawing()).getModel();
        }
        return this.currentModel;
    }

    public Model getModel() {
        return this.currentModel;
    }

    public void setModel(Model model) {
        this.currentModel = model;
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    protected void checkToolsAndMenus() {
        if (this.inspector != null) {
            this.inspector.setReadOnly(this.getViewMode() != 0);
        }
        if (this.notepad != null) {
            this.notepad.setReadOnly(this.getViewMode() != 0);
        }
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_FILE") + "." + Resource.getString("MNU_FILE_SAVE"), this.currentModel != null && this.currentModel.getDirty());
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_FILE") + "." + Resource.getString("MNU_FILE_SAVEAS"), this.currentModel != null);
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_FILE") + "." + Resource.getString("MNU_FILE_EXPORT"), this.currentModel != null);
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_FILE") + "." + Resource.getString("MNU_FILE_PRINT"), this.currentModel != null);
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_FILE") + "." + Resource.getString("MNU_FILE_CLOSE"), this.currentModel != null);
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_WINDOW") + "." + Resource.getString("MNU_WINDOW_GRID"), this.currentModel != null);
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_WINDOW") + "." + Resource.getString("MNU_VIEW_FULLSCREEN"), this.currentModel != null);
        ((MenuBar)this.getJMenuBar()).setRadioItemState(Resource.getString("MNU_VIEW") + "." + Resource.getString("MNU_VIEW_NORMAL"), this.viewMode == 1);
        ((MenuBar)this.getJMenuBar()).setRadioItemState(Resource.getString("MNU_VIEW") + "." + Resource.getString("MNU_VIEW_EDITOR"), this.viewMode == 0);
        ((MenuBar)this.getJMenuBar()).setRadioItemState(Resource.getString("MNU_VIEW") + "." + Resource.getString("MNU_VIEW_FULLSCREEN"), this.viewMode == 2);
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_VIEW") + "." + Resource.getString("MNU_VIEW_EDITOR"), this.modelEditable);
        ((MenuBar)this.getJMenuBar()).setItemState(Resource.getString("MNU_VIEW") + "." + Resource.getString("MNU_VIEW_FULLSCREEN"), this.currentModel != null);
        this.toolbar.enableTool(Resource.getString("TOOL_NEWPROJECT"), true);
        this.toolbar.enableTool(Resource.getString("TOOL_LOAD"), true);
        this.toolbar.enableTool(Resource.getString("TOOL_SAVE"), this.currentModel != null && this.currentModel.getDirty());
        this.toolbar.enableTool(Resource.getString("TOOL_PRINT"), this.currentModel != null);
        String string = new String(Resource.getString("APP_TITLE"));
        if (this.currentModel != null) {
            string = this.loadedModelFilename != null ? string + " - [" + this.loadedModelFilename + "]" : string + " - [" + Resource.getString("PRJ_UNTITLED") + "]";
        }
        if (this.currentModel != null && this.currentModel.getDirty()) {
            string = string + "*";
        }
        if (this.getViewMode() != 0) {
            string = string + " - " + Resource.getString("TXT_READONLY");
        }
        this.setTitle(string);
        this.fireStateChanged();
    }

    public DrawingView getDrawingView() {
        return this.mainpane.getDrawingView();
    }

    public void selectFigure(ModelElement modelElement) {
        if (modelElement == null) {
            return;
        }
        if (modelElement instanceof ModelFigureElement) {
            this.selectFigure(((ModelDrawing)this.getDrawingView().drawing()).getElementFigure(modelElement));
        } else if (modelElement instanceof ModelConnectionElement) {
            this.selectConnection(((ModelDrawing)this.getDrawingView().drawing()).getConnectionFigure((ModelConnectionElement)modelElement));
        }
    }

    public void selectFigure(ModelFigure modelFigure) {
        if (modelFigure == null || this.getDrawingView().isFigureSelected((Figure)modelFigure)) {
            return;
        }
        this.getDrawingView().clearSelection();
        this.getDrawingView().addToSelection((Figure)modelFigure);
    }

    public void selectConnection(ModelConnection modelConnection) {
        if (modelConnection == null || this.getDrawingView().isFigureSelected((Figure)modelConnection)) {
            return;
        }
        this.getDrawingView().clearSelection();
        this.getDrawingView().addToSelection((Figure)modelConnection);
    }

    public void scrollToFigure(ModelFigure modelFigure) {
        if (modelFigure == null) {
            return;
        }
        this.scrollToFigure(modelFigure.getElement());
    }

    public void scrollToFigure(ModelConnection modelConnection) {
        if (modelConnection == null) {
            return;
        }
        this.scrollToFigure(modelConnection.getElement());
    }

    public void scrollToFigure(ModelFigureElement modelFigureElement) {
        if (modelFigureElement == null) {
            return;
        }
        this.activateFrameOfElement(modelFigureElement);
        if (modelFigureElement.getBounds() != null) {
            this.scrollDrawingFrame(new Point(modelFigureElement.getBounds().x, modelFigureElement.getBounds().y));
        }
    }

    public void scrollToFigure(ModelConnectionElement modelConnectionElement) {
        if (modelConnectionElement == null) {
            return;
        }
        this.activateFrameOfElement(modelConnectionElement);
        ModelDrawing modelDrawing = (ModelDrawing)this.getDrawingView().drawing();
        Point point = modelDrawing.getConnectionFigure(modelConnectionElement).center();
        this.scrollDrawingFrame(point);
    }

    public boolean activateFrameOfElement(ModelElement modelElement) {
        Model model = modelElement instanceof Model ? (Model)modelElement : modelElement.getModel();
        for (int i = 0; i < this.mainpane.getTabCount(); ++i) {
            if (!(this.mainpane.getComponent(i) instanceof DrawingPanel) || ((ModelDrawing)((DrawingPanel)this.mainpane.getComponent(i)).getDrawing()).getModel() != model) continue;
            this.mainpane.setSelectedIndex(i);
            return false;
        }
        DrawingView drawingView = this.createDrawingView(model);
        this.mainpane.createDrawingViewTab(drawingView);
        return true;
    }

    public void scrollDrawingFrame(Point point) {
        try {
            JScrollPane jScrollPane = (JScrollPane)this.mainpane.getCurrentPanel().getComponent(0);
            if (jScrollPane == null) {
                return;
            }
            int n = point.y + 40 - this.mainpane.getCurrentPanel().getHeight() / 2;
            int n2 = point.x + 40 - this.mainpane.getCurrentPanel().getWidth() / 2;
            int n3 = jScrollPane.getVerticalScrollBar().getValue();
            int n4 = jScrollPane.getHorizontalScrollBar().getValue();
            if (Math.abs(n - this.oldWantedPos.y) < 10 && Math.abs(n2 - this.oldWantedPos.x) < 10 && Math.abs(n3 - this.oldScrollPos.y) < 10 && Math.abs(n4 - this.oldScrollPos.x) < 10) {
                return;
            }
            jScrollPane.setAutoscrolls(true);
            jScrollPane.getVerticalScrollBar().setValue(n);
            jScrollPane.getHorizontalScrollBar().setValue(n2);
            this.oldWantedPos.y = n;
            this.oldWantedPos.x = n2;
            this.oldScrollPos.y = jScrollPane.getVerticalScrollBar().getValue();
            this.oldScrollPos.x = jScrollPane.getHorizontalScrollBar().getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Rectangle getVisibleAreaOfActiveFrame() {
        Rectangle rectangle = new Rectangle();
        try {
            JScrollPane jScrollPane = (JScrollPane)this.mainpane.getCurrentPanel().getComponent(0);
            if (jScrollPane == null) {
                return null;
            }
            rectangle.y = jScrollPane.getVerticalScrollBar().getValue();
            rectangle.x = jScrollPane.getHorizontalScrollBar().getValue();
            rectangle.width = this.mainpane.getCurrentPanel().getWidth();
            rectangle.height = this.mainpane.getCurrentPanel().getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rectangle;
    }

    public String getCurrentProjectDir() {
        return this.preferences.getString("CurrentDir", null);
    }

    public void setCurrentProjectDir(String string) {
        this.preferences.putString("CurrentDir", string);
    }

    public String getHypertextLocation() {
        if (this.getCurrentProjectDir() == null) {
            return null;
        }
        String string = this.getCurrentProjectDir();
        string.replace('\\', '/');
        string = "file:///" + string;
        if (string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        return string;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int n) {
        if (n == 2) {
            this.setFullScreenMode(n == 2);
        } else if (n != 0) {
            this.showStatus(Resource.getString("TXT_ISPRESENTATIONMODE"));
            this.setReadOnly(true);
        } else {
            this.showStatus(Resource.getString("TXT_ISEDITMODE"));
            this.setReadOnly(false);
        }
        this.previousViewMode = this.viewMode;
        this.viewMode = n;
        this.checkToolsAndMenus();
        this.repaint();
    }

    protected void setReadOnly(boolean bl) {
        if (this.view() instanceof ModelDrawingView) {
            ((ModelDrawingView)this.view()).setReadOnly(bl);
        }
    }

    protected void setFullScreenMode(boolean bl) {
        if (!bl) {
            this.setFullScreenMode(false, null, null, null, null);
            this.setReadOnly(false);
            return;
        }
        Button button = new Button("Close");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Application.this.setFullScreenMode(false, null, null, null, null);
                Application.this.setReadOnly(false);
            }
        });
        this.setFullScreenMode(bl, null, null, button, null);
        this.setReadOnly(true);
    }

    protected void setFullScreenMode(boolean bl, Component component, Component component2, Component component3, Component component4) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        if (bl) {
            Window window = new Window(this);
            this.activeDrawingPanel = (DrawingPanel)this.mainpane.getCurrentPanel();
            window.add((Component)this.activeDrawingPanel, "Center");
            if (component != null) {
                window.add(component, "North");
            }
            if (component2 != null) {
                window.add(component2, "South");
            }
            if (component3 != null) {
                window.add(component3, "East");
            }
            if (component4 != null) {
                window.add(component4, "West");
            }
            this.savedState = this.getExtendedState();
            this.setExtendedState(1);
            graphicsDevice.setFullScreenWindow(window);
        } else {
            graphicsDevice.getFullScreenWindow().remove(this.activeDrawingPanel);
            this.mainpane.createDrawingViewTab(this.activeDrawingPanel.getDrawingView());
            graphicsDevice.setFullScreenWindow(null);
            this.setExtendedState(this.savedState);
            this.setViewMode(this.previousViewMode);
        }
        this.repaint();
        this.checkToolsAndMenus();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getSource() instanceof DrawingPanel) {
            DrawingPanel drawingPanel = (DrawingPanel)componentEvent.getSource();
            this.deactivatePanel(drawingPanel);
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getSource() instanceof DrawingPanel) {
            DrawingPanel drawingPanel = (DrawingPanel)componentEvent.getSource();
            this.activatePanel(drawingPanel);
            this.checkToolsAndMenus();
        }
    }

    protected abstract String[] getModelClassPrefix();

    protected File getConfigPath() {
        File file = new File(this.getUserHome() + File.separatorChar + ".limo");
        File file2 = new File(file, this.getApplicationName() + ".cfg");
        return file2;
    }

    public void saveParams() {
        int n = this.getExtendedState();
        this.preferences.putInt("WindowXCoord", this.getBounds().x);
        this.preferences.putInt("WindowYCoord", this.getBounds().y);
        this.preferences.putInt("WindowWidth", this.getBounds().width);
        this.preferences.putInt("WindowHeight", this.getBounds().height);
        this.preferences.putInt("LeftSplit", this.leftSplitPane.getDividerLocation());
        this.preferences.putInt("RightSplit", this.rightSplitPane.getDividerLocation());
        this.preferences.putInt("LastLeftSplit", this.leftSplitPos);
        this.preferences.putInt("LastRightSplit", this.rightSplitPos);
        this.preferences.putInt("ControlSplit", this.controlPane.getDividerLocation());
        this.preferences.putInt("WindowState", n);
        this.preferences.putInt("Grid", this.mainpane.getGrid() ? 1 : 0);
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            this.preferences.putString("RecentFile" + (i + 1), (String)this.recentFiles.get(i));
        }
        this.preferences.putString("LookAndFeel", this.getLookAndFeel());
        this.preferences.putString("MetalTheme", this.getMetalTheme());
        File file = new File(this.getUserHome() + File.separatorChar + ".limo");
        int n2 = this.preferences.getInt("NumberOfLaunches", 0) + 1;
        this.preferences.putInt("NumberOfLaunches", n2);
        this.preferences.save(this.getConfigPath().getAbsolutePath());
    }

    public void loadParams() {
        this.preferences = new Preferences(this.getConfigPath().getAbsolutePath());
        this.firstStart = this.preferences.getInt("NumberOfLaunches", 0) == 0;
        int n = this.preferences.getInt("WindowXCoord", 0);
        int n2 = this.preferences.getInt("WindowYCoord", 0);
        int n3 = this.preferences.getInt("WindowWidth", 800);
        int n4 = this.preferences.getInt("WindowHeight", 600);
        this.setBounds(n, n2, n3, n4);
        int n5 = this.preferences.getInt("LeftSplit", 220);
        int n6 = this.preferences.getInt("RightSplit", 320);
        int n7 = this.preferences.getInt("LastLeftSplit", 220);
        int n8 = this.preferences.getInt("LastRightSplit", 320);
        int n9 = this.preferences.getInt("ControlSplit", 250);
        this.leftSplitPane.setDividerLocation(n5);
        this.leftSplitPos = n7;
        this.rightSplitPane.setDividerLocation(n6);
        this.rightSplitPos = n8;
        this.controlPane.setDividerLocation(n9);
        this.controlPane.setLastDividerLocation(n9);
        int n10 = this.preferences.getInt("WindowState", 0);
        this.doMaximize = n10 == 6;
        this.setLastPrintersName(this.preferences.getString("LastPrinter", null));
        this.setCurrentProjectDir(this.preferences.getString("CurrentDir", System.getProperty("user.home")));
        for (int i = 5; i >= 1; --i) {
            String string = this.preferences.getString("RecentFile" + i, null);
            if (string == null || string.equals("")) continue;
            this.addToRescentFiles(string);
        }
        this.mainpane.setGrid(this.preferences.getInt("Grid") == 1);
        this.setLookAndFeel(this.preferences.getString("LookAndFeel", this.getLookAndFeel()), this.preferences.getString("MetalTheme", this.getMetalTheme()));
    }

    private void addToRescentFiles(String string) {
        if (this.recentFiles.indexOf(string) > -1) {
            return;
        }
        this.recentFiles.insertElementAt(string, 0);
        if (this.recentFiles.size() > 5) {
            this.recentFiles.remove(5);
        }
        ((MenuBar)this.getJMenuBar()).setRecentFiles(this.recentFiles);
    }

    protected void showHelp() {
        if (this.help == null) {
            this.help = new HypertextViewer(this, Resource.getString("MNU_HELP"), false);
        }
        URL uRL = this.getClass().getResource(Resource.getString("HELP_URL"));
        this.help.setPage(uRL);
        this.removeComponentFromTab(this.help);
        this.showComponentInTab(this.help, 1, true);
        this.showRightPane(true);
    }

    protected void showAboutDialog() {
        AboutDialog aboutDialog = new AboutDialog(this);
    }

    protected int getListenerCount() {
        return this.listeners.size();
    }

    protected ApplicationListener getListener(int n) {
        return (ApplicationListener)this.listeners.elementAt(n);
    }

    public int addListener(ApplicationListener applicationListener) {
        if (this.listeners.contains(applicationListener)) {
            System.err.println("Warning: " + applicationListener + " already listening to " + this);
        } else {
            this.listeners.addElement(applicationListener);
        }
        return this.listeners.size();
    }

    public void removeListener(ApplicationListener applicationListener) {
        this.listeners.removeElement(applicationListener);
    }

    public void fireModelSelectionChanged(ModelElement[] modelElementArray) {
        for (int i = this.getListenerCount() - 1; i >= 0; --i) {
            this.getListener(i).onModelSelectionChanged(this, this.getModel(), modelElementArray);
        }
    }

    public void fireStateChanged() {
        for (int i = this.getListenerCount() - 1; i >= 0; --i) {
            this.getListener(i).onStateChanged(this);
        }
    }

    public void showComponentInTab(JPanel jPanel, int n, boolean bl) {
        ComponentPane componentPane = null;
        switch (n & 0xF) {
            case 1: {
                componentPane = this.hypertextpane;
                break;
            }
            case 2: {
                componentPane = this.mainpane;
                break;
            }
            case 4: {
                componentPane = this.controlPane.getTopPane();
                break;
            }
            case 8: {
                componentPane = this.controlPane.getBottomPane();
                break;
            }
            default: {
                new IllegalArgumentException("Application.showComponentInTab() mit falschem Wert f\ufffdr panePosition aufgerufen!");
            }
        }
        if (componentPane != null) {
            this.componentsPanes.put(jPanel, componentPane);
            componentPane.addTabForComponent(jPanel);
            if (bl) {
                componentPane.selectComponent(jPanel);
                jPanel.setVisible(true);
            }
        }
    }

    public void selectComponentInTab(JPanel jPanel) {
        ComponentPane componentPane = this.getPaneOfComponent(jPanel);
        if (componentPane != null) {
            componentPane.selectComponent(jPanel);
        }
    }

    public void enableComponentInTab(JPanel jPanel, boolean bl) {
        ComponentPane componentPane = this.getPaneOfComponent(jPanel);
        if (componentPane != null) {
            componentPane.setComponentTabEnabled(jPanel, bl);
        }
    }

    public boolean removeComponentFromTab(JPanel jPanel) {
        ComponentPane componentPane = this.getPaneOfComponent(jPanel);
        if (componentPane != null) {
            this.componentsPanes.remove(jPanel);
            return componentPane.removeTabForComponent(jPanel);
        }
        return false;
    }

    public ComponentPane getPaneOfComponent(JPanel jPanel) {
        return (ComponentPane)this.componentsPanes.get(jPanel);
    }

    public HypertextEditor getHypertextEditor() {
        return this.hypertextEditor;
    }

    public HypertextViewer getHypertextViewer() {
        return this.hypertextViewer;
    }

    public PropertyPanel getInspector() {
        return this.inspector;
    }

    public RessourceTree getNavigator() {
        return this.navigator;
    }

    public NoticeEditor getNotepad() {
        return this.notepad;
    }

    public ResourceQuickView getBirdsEye() {
        return this.birdsEye;
    }

    public void repairDamage() {
        if (this.getDrawingView() != null) {
            this.getDrawingView().repairDamage();
        }
    }

    public String getApplicationName() {
        return "limo";
    }

    public String getApplicationTitle() {
        return "Unknown";
    }

    public String getApplicationVersion() {
        return "Unknown";
    }

    public String getUserHome() {
        return System.getProperty("user.home", ".");
    }

    public String getLastPrintersName() {
        String string = this.preferences.getString("LastPrinter", null);
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    public void setLastPrintersName(String string) {
        if (string == null) {
            string = "";
        }
        this.preferences.putString("LastPrinter", string);
    }

    public void followPointer(int n, int n2) {
        JScrollPane jScrollPane = (JScrollPane)this.mainpane.getCurrentPanel().getComponent(0);
        if (jScrollPane == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(jScrollPane.getHorizontalScrollBar().getValue(), jScrollPane.getVerticalScrollBar().getValue(), jScrollPane.getHorizontalScrollBar().getWidth(), jScrollPane.getVerticalScrollBar().getHeight());
        if (rectangle == null) {
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        if (n < rectangle.x + 5) {
            n3 = rectangle.x - 15;
        }
        if (n2 < rectangle.y + 5) {
            n4 = rectangle.y - 15;
        }
        if (n > rectangle.x + rectangle.width - 5) {
            n3 = rectangle.x + 15;
        }
        if (n2 > rectangle.y + rectangle.height - 5) {
            n4 = rectangle.y + 15;
        }
        if (n3 != rectangle.x) {
            jScrollPane.getHorizontalScrollBar().setValue(n3);
        }
        if (n4 != rectangle.y) {
            jScrollPane.getVerticalScrollBar().setValue(n4);
        }
    }

    public void openURLInBrowser(String string) {
        String[] stringArray;
        string = string.replaceAll("\\s", "%20");
        if (this.osName.equals("Linux")) {
            stringArray = new String[]{"mozilla", string};
        } else if (this.osName.equals("Windows 95") || this.osName.startsWith("Windows 98") || this.osName.startsWith("Windows ME")) {
            stringArray = new String[]{"command", "/c start " + string};
        } else if (this.osName.startsWith("Windows")) {
            stringArray = new String[]{"cmd", "/c start " + string};
        } else if (this.osName.startsWith("Mac")) {
            stringArray = new String[]{"open", string};
        } else {
            LogFile.log("Betriebssystem kann nicht identifiziert werden.");
            return;
        }
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            LogFile.log("Kann URL nicht \ufffdffnen, keine Verbindung", LogFile.WARNING);
            JOptionPane.showMessageDialog(this, Resource.getString("DLG_URL_MESSAGE") + "\"" + string + "\"", Resource.getString("DLG_URL_NOROUTE"), 2);
        }
        catch (IOException iOException) {
            LogFile.log("Kann Webbrowser nicht lokalisieren", LogFile.WARNING);
            JOptionPane.showMessageDialog(this, Resource.getString("DLG_URL_MESSAGE") + "\"" + string + "\"", Resource.getString("DLG_URL_TITLE"), 2);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        int n2;
        if (propertyChangeEvent.getSource() == this.rightSplitPane && (n2 = ((Integer)propertyChangeEvent.getNewValue()).intValue()) != (n = this.getBounds().width - this.leftSplitPane.getDividerLocation() - 30)) {
            this.rightSplitPos = n2;
        }
        if (propertyChangeEvent.getSource() == this.leftSplitPane && (n2 = ((Integer)propertyChangeEvent.getNewValue()).intValue()) > 1) {
            this.leftSplitPos = n2;
        }
    }

    public Hashtable getComponentsPanes() {
        return this.componentsPanes;
    }

    public String getLoadedModelFilename() {
        return this.loadedModelFilename;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public static String getParameter(String[] stringArray, String string, String string2) {
        string = "-" + string;
        String string3 = string2;
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            if (!string.equals(stringArray[i])) continue;
            string3 = stringArray[i + 1];
            break;
        }
        return string3;
    }

    public String getLookAndFeel() {
        return UIManager.getLookAndFeel().getClass().getName();
    }

    public String getMetalTheme() {
        return Themer.getInstance().getMetalTheme();
    }

    public void setLookAndFeel(String string, String string2) {
        if (!this.getLookAndFeel().equals(string) || !Themer.getInstance().getMetalTheme().equals(string2)) {
            try {
                if (string2 != null) {
                    Themer.getInstance().setMetalTheme(string2);
                }
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (Exception exception) {
                LogFile.log(exception);
            }
        }
    }

    public Logger createLogger() {
        File file = new File(this.getUserHome() + File.separatorChar + ".limo");
        file.mkdirs();
        Logger logger = Logger.getLogger("org.musoft.limo");
        logger.setLevel(Level.INFO);
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SimpleFormatter());
        logger.addHandler(consoleHandler);
        String string = file.getAbsolutePath() + File.separatorChar + this.getApplicationName() + ".log";
        try {
            FileHandler fileHandler = new FileHandler(string, true);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            logger.warning("Unable to open logfile \"" + string + "\"");
        }
        return logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

