/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.Cursor;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class UndoableHandle
implements Handle {
    private Handle myWrappedHandle;
    private DrawingView myDrawingView;

    public UndoableHandle(Handle newWrappedHandle) {
        this.setWrappedHandle(newWrappedHandle);
    }

    public UndoableHandle(Handle newWrappedHandle, DrawingView newDrawingView) {
        this.setWrappedHandle(newWrappedHandle);
        this.setDrawingView(newDrawingView);
    }

    public Point locate() {
        return this.getWrappedHandle().locate();
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.getWrappedHandle().invokeStart(x, y, view);
    }

    public void invokeStart(int x, int y, Drawing drawing) {
        this.getWrappedHandle().invokeStart(x, y, drawing);
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.getWrappedHandle().invokeStep(x, y, anchorX, anchorY, view);
    }

    public void invokeStep(int dx, int dy, Drawing drawing) {
        this.getWrappedHandle().invokeStep(dx, dy, drawing);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.getWrappedHandle().invokeEnd(x, y, anchorX, anchorY, view);
        Undoable undoableActivity = this.getWrappedHandle().getUndoActivity();
        if (undoableActivity != null && undoableActivity.isUndoable()) {
            view.editor().getUndoManager().pushUndo(undoableActivity);
            view.editor().getUndoManager().clearRedos();
        }
    }

    public void invokeEnd(int dx, int dy, Drawing drawing) {
        this.getWrappedHandle().invokeEnd(dx, dy, drawing);
    }

    public Figure owner() {
        return this.getWrappedHandle().owner();
    }

    public Rectangle displayBox() {
        return this.getWrappedHandle().displayBox();
    }

    public boolean containsPoint(int x, int y) {
        return this.getWrappedHandle().containsPoint(x, y);
    }

    public void draw(Graphics g) {
        this.getWrappedHandle().draw(g);
    }

    protected void setWrappedHandle(Handle newWrappedHandle) {
        this.myWrappedHandle = newWrappedHandle;
    }

    protected Handle getWrappedHandle() {
        return this.myWrappedHandle;
    }

    public DrawingView getDrawingView() {
        return this.myDrawingView;
    }

    protected void setDrawingView(DrawingView newDrawingView) {
        this.myDrawingView = newDrawingView;
    }

    public Undoable getUndoActivity() {
        return new UndoableAdapter(this.getDrawingView());
    }

    public void setUndoActivity(Undoable newUndoableActivity) {
    }

    public Cursor getCursor() {
        return this.getWrappedHandle().getCursor();
    }
}

