/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.util.EventObject;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureSelectionListener;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.CommandListener;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class UndoableCommand
implements Command,
FigureSelectionListener,
CommandListener {
    private Command myWrappedCommand;
    private boolean hasSelectionChanged;
    private AbstractCommand.EventDispatcher myEventDispatcher;

    public UndoableCommand(Command newWrappedCommand) {
        this.setWrappedCommand(newWrappedCommand);
        this.getWrappedCommand().addCommandListener(this);
        this.setEventDispatcher(this.createEventDispatcher());
    }

    public void execute() {
        this.hasSelectionChanged = false;
        this.view().addFigureSelectionListener(this);
        this.getWrappedCommand().execute();
        Undoable undoableCommand = this.getWrappedCommand().getUndoActivity();
        if (undoableCommand != null && undoableCommand.isUndoable()) {
            this.getDrawingEditor().getUndoManager().pushUndo(undoableCommand);
            this.getDrawingEditor().getUndoManager().clearRedos();
        }
        if (!this.hasSelectionChanged || this.getDrawingEditor().getUndoManager().getUndoSize() == 1) {
            this.getDrawingEditor().figureSelectionChanged(this.view());
        }
        this.view().removeFigureSelectionListener(this);
    }

    public boolean isExecutable() {
        return this.getWrappedCommand().isExecutable();
    }

    protected void setWrappedCommand(Command newWrappedCommand) {
        this.myWrappedCommand = newWrappedCommand;
    }

    protected Command getWrappedCommand() {
        return this.myWrappedCommand;
    }

    public String name() {
        return this.getWrappedCommand().name();
    }

    public DrawingEditor getDrawingEditor() {
        return this.getWrappedCommand().getDrawingEditor();
    }

    public DrawingView view() {
        return this.getDrawingEditor().view();
    }

    public void figureSelectionChanged(DrawingView view) {
        this.hasSelectionChanged = true;
    }

    public Undoable getUndoActivity() {
        return new UndoableAdapter(this.view());
    }

    public void setUndoActivity(Undoable newUndoableActivity) {
    }

    public void addCommandListener(CommandListener newCommandListener) {
        this.getEventDispatcher().addCommandListener(newCommandListener);
    }

    public void removeCommandListener(CommandListener oldCommandListener) {
        this.getEventDispatcher().removeCommandListener(oldCommandListener);
    }

    private void setEventDispatcher(AbstractCommand.EventDispatcher newEventDispatcher) {
        this.myEventDispatcher = newEventDispatcher;
    }

    protected AbstractCommand.EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    public AbstractCommand.EventDispatcher createEventDispatcher() {
        return new AbstractCommand.EventDispatcher(this);
    }

    public void commandExecuted(EventObject commandEvent) {
        this.getEventDispatcher().fireCommandExecutedEvent();
    }

    public void commandExecutable(EventObject commandEvent) {
        this.getEventDispatcher().fireCommandExecutableEvent();
    }

    public void commandNotExecutable(EventObject commandEvent) {
        this.getEventDispatcher().fireCommandNotExecutableEvent();
    }
}

