/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorageFormat;

public class StorageFormatManager {
    private List myStorageFormats = CollectionsFactory.current().createList();
    private StorageFormat myDefaultStorageFormat;

    public void addStorageFormat(StorageFormat newStorageFormat) {
        this.myStorageFormats.add(newStorageFormat);
    }

    public void removeStorageFormat(StorageFormat oldStorageFormat) {
        this.myStorageFormats.remove(oldStorageFormat);
    }

    public boolean containsStorageFormat(StorageFormat checkStorageFormat) {
        return this.myStorageFormats.contains(checkStorageFormat);
    }

    public void setDefaultStorageFormat(StorageFormat newDefaultStorageFormat) {
        this.myDefaultStorageFormat = newDefaultStorageFormat;
    }

    public StorageFormat getDefaultStorageFormat() {
        return this.myDefaultStorageFormat;
    }

    public void registerFileFilters(JFileChooser fileChooser) {
        if (fileChooser.getDialogType() == 0) {
            StorageFormat sf2;
            for (StorageFormat sf2 : this.myStorageFormats) {
                if (!sf2.isRestoreFormat()) continue;
                fileChooser.addChoosableFileFilter(sf2.getFileFilter());
            }
            sf2 = this.getDefaultStorageFormat();
            if (sf2 != null && sf2.isRestoreFormat()) {
                fileChooser.setFileFilter(sf2.getFileFilter());
            }
        } else if (fileChooser.getDialogType() == 1) {
            StorageFormat sf3;
            for (StorageFormat sf3 : this.myStorageFormats) {
                if (!sf3.isStoreFormat()) continue;
                fileChooser.addChoosableFileFilter(sf3.getFileFilter());
            }
            sf3 = this.getDefaultStorageFormat();
            if (sf3 != null && sf3.isStoreFormat()) {
                fileChooser.setFileFilter(sf3.getFileFilter());
            }
        } else {
            StorageFormat sf4;
            for (StorageFormat sf4 : this.myStorageFormats) {
                fileChooser.addChoosableFileFilter(sf4.getFileFilter());
            }
            sf4 = this.getDefaultStorageFormat();
            if (sf4 != null) {
                fileChooser.setFileFilter(sf4.getFileFilter());
            }
        }
    }

    public StorageFormat findStorageFormat(FileFilter findFileFilter) {
        Iterator formatsIterator = this.myStorageFormats.iterator();
        StorageFormat currentStorageFormat = null;
        while (formatsIterator.hasNext()) {
            currentStorageFormat = (StorageFormat)formatsIterator.next();
            if (!currentStorageFormat.getFileFilter().equals(findFileFilter)) continue;
            return currentStorageFormat;
        }
        return null;
    }

    public StorageFormat findStorageFormat(File file) {
        for (StorageFormat currentStorageFormat : this.myStorageFormats) {
            if (!currentStorageFormat.getFileFilter().accept(file)) continue;
            return currentStorageFormat;
        }
        return null;
    }
}

