/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.util.StandardStorageFormat;

public class SerializationStorageFormat
extends StandardStorageFormat {
    protected String createFileExtension() {
        return "ser";
    }

    public String createFileDescription() {
        return "Serialization (" + this.getFileExtension() + ")";
    }

    public String store(String fileName, Drawing saveDrawing) throws IOException {
        FileOutputStream stream = new FileOutputStream(this.adjustFileName(fileName));
        ObjectOutputStream output = new ObjectOutputStream(stream);
        output.writeObject(saveDrawing);
        output.close();
        return this.adjustFileName(fileName);
    }

    public Drawing restore(String fileName) throws IOException {
        try {
            FileInputStream stream = new FileInputStream(fileName);
            ObjectInputStream input = new ObjectInputStream(stream);
            return (Drawing)input.readObject();
        }
        catch (ClassNotFoundException exception) {
            throw new IOException("Could not restore drawing '" + fileName + "': class not found!");
        }
    }
}

