/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;

public class PaletteLayout
implements LayoutManager {
    private int fGap;
    private Point fBorder;
    private boolean fVerticalLayout;

    public PaletteLayout(int gap) {
        this(gap, new Point(0, 0), true);
    }

    public PaletteLayout(int gap, Point border) {
        this(gap, border, true);
    }

    public PaletteLayout(int gap, Point border, boolean vertical) {
        this.fGap = gap;
        this.fBorder = border;
        this.fVerticalLayout = vertical;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.minimumLayoutSize(target);
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = new Dimension(0, 0);
        int nmembers = target.getComponentCount();
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getMinimumSize();
                if (this.fVerticalLayout) {
                    dim.width = Math.max(dim.width, d.width);
                    if (i > 0) {
                        dim.height += this.fGap;
                    }
                    dim.height += d.height;
                } else {
                    dim.height = Math.max(dim.height, d.height);
                    if (i > 0) {
                        dim.width += this.fGap;
                    }
                    dim.width += d.width;
                }
            }
            ++i;
        }
        Insets insets = target.getInsets();
        dim.width += insets.left + insets.right;
        dim.width += 2 * this.fBorder.x;
        dim.height += insets.top + insets.bottom;
        dim.height += 2 * this.fBorder.y;
        return dim;
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int nmembers = target.getComponentCount();
        int x = insets.left + this.fBorder.x;
        int y = insets.top + this.fBorder.y;
        int i = 0;
        while (i < nmembers) {
            Component m = target.getComponent(i);
            if (m.isVisible()) {
                Dimension d = m.getMinimumSize();
                m.setBounds(x, y, d.width, d.height);
                if (this.fVerticalLayout) {
                    y += d.height;
                    y += this.fGap;
                } else {
                    x += d.width;
                    x += this.fGap;
                }
            }
            ++i;
        }
    }
}

