/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.swing.AbstractListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StandardStorageFormat;

public class JDOStorageFormat
extends StandardStorageFormat {
    private Map pms = CollectionsFactory.current().createMap();

    public JDOStorageFormat() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Iterator iter = JDOStorageFormat.this.pms.values().iterator();
            }
        });
    }

    protected String createFileExtension() {
        return "j2";
    }

    public String createFileDescription() {
        return "Database (" + this.getFileExtension() + ")";
    }

    public boolean isRestoreFormat() {
        return true;
    }

    public boolean isStoreFormat() {
        return true;
    }

    public String store(String fileName, Drawing storeDrawing) throws IOException {
        PersistenceManager pm = this.getPersistenceManager(fileName);
        String drawingName = null;
        Drawing txnDrawing = this.crossTxnBoundaries(storeDrawing);
        JDOStorageFormat.endTransaction(pm, false);
        JDOStorageFormat.startTransaction(pm);
        try {
            Extent extent = pm.getExtent(StandardDrawing.class, true);
            DrawingListModel listModel = new DrawingListModel(extent.iterator());
            drawingName = this.showStoreDialog(listModel, storeDrawing);
            if (drawingName != null) {
                storeDrawing.setTitle(drawingName);
                txnDrawing.setTitle(drawingName);
                pm.makePersistent((Object)txnDrawing);
            }
        }
        catch (Throwable throwable) {
            JDOStorageFormat.endTransaction(pm, drawingName != null);
            throw throwable;
        }
        JDOStorageFormat.endTransaction(pm, drawingName != null);
        JDOStorageFormat.startTransaction(pm);
        return drawingName;
    }

    public synchronized Drawing restore(String fileName) throws IOException {
        PersistenceManager pm = this.getPersistenceManager(fileName);
        JDOStorageFormat.endTransaction(pm, false);
        JDOStorageFormat.startTransaction(pm);
        Drawing restoredDrawing = null;
        try {
            Extent extent = pm.getExtent(StandardDrawing.class, true);
            DrawingListModel listModel = new DrawingListModel(extent.iterator());
            Drawing txnDrawing = this.showRestoreDialog(listModel);
            if (txnDrawing != null) {
                restoredDrawing = txnDrawing;
            }
        }
        finally {
            JDOStorageFormat.endTransaction(pm, false);
        }
        JDOStorageFormat.startTransaction(pm);
        return restoredDrawing;
    }

    private void retrieveAll(PersistenceManager pm, Figure figure) {
        pm.retrieve((Object)figure);
        FigureEnumeration fe = figure.figures();
        while (fe.hasNextFigure()) {
            this.retrieveAll(pm, fe.nextFigure());
        }
    }

    private Drawing crossTxnBoundaries(Drawing originalDrawing) {
        return (Drawing)((StandardDrawing)originalDrawing).clone();
    }

    private synchronized PersistenceManager getPersistenceManager(String fileName) {
        PersistenceManager pm = (PersistenceManager)this.pms.get(fileName);
        if (pm == null) {
            pm = this.createPersistenceManagerFactory(fileName).getPersistenceManager();
            this.pms.put(fileName, pm);
        }
        return pm;
    }

    private PersistenceManagerFactory createPersistenceManagerFactory(String dbFileName) {
        Properties pmfProps = new Properties();
        pmfProps.put("javax.jdo.PersistenceManagerFactoryClass", "com.poet.jdo.PersistenceManagerFactories");
        pmfProps.put("javax.jdo.option.ConnectionURL", "fastobjects://LOCAL/MyBase.j1");
        PersistenceManagerFactory pmf = JDOHelper.getPersistenceManagerFactory((Map)pmfProps);
        return pmf;
    }

    private static void startTransaction(PersistenceManager pm) {
        if (!pm.currentTransaction().isActive()) {
            pm.currentTransaction().begin();
        }
    }

    private static void endTransaction(PersistenceManager pm, boolean doCommit) {
        if (pm.currentTransaction().isActive()) {
            if (doCommit) {
                pm.currentTransaction().commit();
            } else {
                pm.currentTransaction().rollback();
            }
        }
    }

    private String showStoreDialog(ListModel listModel, Drawing storeDrawing) {
        String msgString = "Specify a name for the drawing";
        final JTextField nameTextField = new JTextField(storeDrawing.getTitle());
        final JList dataList = new JList(listModel);
        JScrollPane dbContentScrollPane = new JScrollPane(dataList);
        Object[] guiComponents = new Object[]{"Specify a name for the drawing", dbContentScrollPane, nameTextField};
        dataList.setSelectionMode(0);
        dataList.setValueIsAdjusting(true);
        dataList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                nameTextField.setText(dataList.getSelectedValue().toString());
            }
        });
        JOptionPane optionPane = new JOptionPane(guiComponents, -1, 2);
        JDialog dialog = optionPane.createDialog(null, "Restore a drawing from the database");
        dialog.setVisible(true);
        if (optionPane.getValue() != null && optionPane.getValue().equals(new Integer(0))) {
            return nameTextField.getText();
        }
        return null;
    }

    private Drawing showRestoreDialog(DrawingListModel listModel) {
        String msgString = "Select a drawing";
        JList dataList = new JList(listModel);
        JScrollPane dbContentScrollPane = new JScrollPane(dataList);
        Object[] guiComponents = new Object[]{"Select a drawing", dbContentScrollPane};
        dataList.setSelectionMode(0);
        dataList.setValueIsAdjusting(true);
        JOptionPane optionPane = new JOptionPane(guiComponents, -1, 2);
        JDialog dialog = optionPane.createDialog(null, "Restore a drawing from the database");
        dialog.setVisible(true);
        if (optionPane.getValue() != null && optionPane.getValue().equals(new Integer(0)) && dataList.getSelectedIndex() >= 0 && dataList.getSelectedIndex() < dataList.getModel().getSize()) {
            return listModel.getDrawingAt(dataList.getSelectedIndex());
        }
        return null;
    }

    public static void main(String[] args) {
        DrawingSelector frame = new DrawingSelector();
        try {
            StandardDrawing newDrawing = new StandardDrawing();
            newDrawing.setTitle("TestDrawingName" + new Random(System.currentTimeMillis()).nextLong());
            new JDOStorageFormat().store("base.j2", newDrawing);
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class DrawingListModel
    extends AbstractListModel {
        private List myList = CollectionsFactory.current().createList();

        DrawingListModel(Iterator iter) {
            while (iter.hasNext()) {
                Object o = iter.next();
                System.out.println("extent: " + o + " .. " + ((Drawing)o).getTitle());
                this.myList.add(o);
            }
        }

        public Object getElementAt(int index) {
            return this.getDrawingAt(index).getTitle();
        }

        protected Drawing getDrawingAt(int index) {
            return (Drawing)this.myList.get(index);
        }

        public int getSize() {
            return this.myList.size();
        }
    }

    static class DrawingSelector
    extends JDialog {
        DrawingSelector() {
            this.init();
        }

        private void init() {
            this.setTitle("Select Drawing");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JLabel("Database content"), "North");
            this.setSize(200, 200);
        }
    }
}

