/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Bounds
implements Serializable {
    protected double _dX1 = 0.0;
    protected double _dY1 = 0.0;
    protected double _dX2 = 0.0;
    protected double _dY2 = 0.0;

    public Bounds(double x, double y) {
        this._dX1 = x;
        this._dX2 = x;
        this._dY1 = y;
        this._dY2 = y;
    }

    public Bounds(double x1, double y1, double x2, double y2) {
        this._dX1 = Math.min(x1, x2);
        this._dX2 = Math.max(x1, x2);
        this._dY1 = Math.min(y1, y2);
        this._dY2 = Math.max(y1, y2);
    }

    public Bounds(Point2D aPoint2D) {
        this(aPoint2D.getX(), aPoint2D.getY());
    }

    public Bounds(Point2D firstPoint2D, Point2D secondPoint2D) {
        this(firstPoint2D.getX(), firstPoint2D.getY(), secondPoint2D.getX(), secondPoint2D.getY());
    }

    public Bounds(Bounds aBounds) {
        this(aBounds.getLesserX(), aBounds.getLesserY(), aBounds.getGreaterX(), aBounds.getGreaterY());
    }

    public Bounds(Rectangle2D aRectangle2D) {
        this._dX1 = aRectangle2D.getMinX();
        this._dX2 = aRectangle2D.getMaxX();
        this._dY1 = aRectangle2D.getMinY();
        this._dY2 = aRectangle2D.getMaxY();
    }

    public Bounds(Point2D centerPoint2D, double dWidth, double dHeight) {
        this._dX1 = centerPoint2D.getX() - dWidth / 2.0;
        this._dX2 = centerPoint2D.getX() + dWidth / 2.0;
        this._dY1 = centerPoint2D.getY() - dHeight / 2.0;
        this._dY2 = centerPoint2D.getY() + dHeight / 2.0;
    }

    public Bounds(Dimension aDimension) {
        this(0.0, 0.0, aDimension.width, aDimension.height);
    }

    protected Bounds() {
    }

    public double getLesserX() {
        return this._dX1;
    }

    public double getGreaterX() {
        return this._dX2;
    }

    public double getLesserY() {
        return this._dY1;
    }

    public double getGreaterY() {
        return this._dY2;
    }

    public double getWest() {
        return this._dX1;
    }

    public double getEast() {
        return this._dX2;
    }

    public double getSouth() {
        return this._dY1;
    }

    public double getNorth() {
        return this._dY2;
    }

    public double getWidth() {
        return this._dX2 - this._dX1;
    }

    public double getHeight() {
        return this._dY2 - this._dY1;
    }

    public Rectangle2D asRectangle2D() {
        return new Rectangle2D.Double(this.getLesserX(), this.getLesserY(), this.getWidth(), this.getHeight());
    }

    public void setCenter(Point2D centerPoint2D) {
        if (centerPoint2D == null) {
            throw new IllegalArgumentException();
        }
        Point2D currentCenterPoint2D = this.getCenter();
        double dDeltaX = centerPoint2D.getX() - currentCenterPoint2D.getX();
        double dDeltaY = centerPoint2D.getY() - currentCenterPoint2D.getY();
        this.offset(dDeltaX, dDeltaY);
    }

    public Point2D getCenter() {
        return new Point2D.Double((this._dX1 + this._dX2) / 2.0, (this._dY1 + this._dY2) / 2.0);
    }

    public void zoomBy(double dRatio) {
        double dWidth = this._dX2 - this._dX1;
        double dHeight = this._dY2 - this._dY1;
        double dNewWidth = dWidth * dRatio;
        double dNewHeight = dHeight * dRatio;
        Point2D centerPoint2D = this.getCenter();
        this._dX1 = centerPoint2D.getX() - dNewWidth / 2.0;
        this._dY1 = centerPoint2D.getY() - dNewHeight / 2.0;
        this._dX2 = centerPoint2D.getX() + dNewWidth / 2.0;
        this._dY2 = centerPoint2D.getY() + dNewHeight / 2.0;
    }

    public void shiftBy(int nXPercentage, int nYPercentage) {
        double dWidth = this._dX2 - this._dX1;
        double dHeight = this._dY2 - this._dY1;
        double dDeltaX = dWidth * (double)nXPercentage / 100.0;
        double dDeltaY = dHeight * (double)nYPercentage / 100.0;
        this.offset(dDeltaX, dDeltaY);
    }

    public void offset(double dDeltaX, double dDeltaY) {
        this._dX1 += dDeltaX;
        this._dX2 += dDeltaX;
        this._dY1 += dDeltaY;
        this._dY2 += dDeltaY;
    }

    public void expandToRatio(double dRatio) {
        double dDelta;
        double dCurrentRatio = this.getWidth() / this.getHeight();
        if (dCurrentRatio < dRatio) {
            double dNewWidth = dRatio * this.getHeight();
            double dCenterX = (this._dX1 + this._dX2) / 2.0;
            dDelta = dNewWidth / 2.0;
            this._dX1 = dCenterX - dDelta;
            this._dX2 = dCenterX + dDelta;
        }
        if (dCurrentRatio > dRatio) {
            double dNewHeight = this.getWidth() / dRatio;
            double dCenterY = (this._dY1 + this._dY2) / 2.0;
            dDelta = dNewHeight / 2.0;
            this._dY1 = dCenterY - dDelta;
            this._dY2 = dCenterY + dDelta;
        }
    }

    public void includeXCoordinate(double x) {
        this._dX1 = this.min(this._dX1, this._dX2, x);
        this._dX2 = this.max(this._dX1, this._dX2, x);
    }

    public void includeYCoordinate(double y) {
        this._dY1 = this.min(this._dY1, this._dY2, y);
        this._dY2 = this.max(this._dY1, this._dY2, y);
    }

    public void includePoint(double x, double y) {
        this.includeXCoordinate(x);
        this.includeYCoordinate(y);
    }

    public void includePoint(Point2D aPoint2D) {
        this.includePoint(aPoint2D.getX(), aPoint2D.getY());
    }

    public void includeLine(double x1, double y1, double x2, double y2) {
        this.includePoint(x1, y1);
        this.includePoint(x2, y2);
    }

    public void includeLine(Point2D onePoint2D, Point2D twoPoint2D) {
        this.includeLine(onePoint2D.getX(), onePoint2D.getY(), twoPoint2D.getX(), twoPoint2D.getY());
    }

    public void includeBounds(Bounds aBounds) {
        this.includeXCoordinate(aBounds.getLesserX());
        this.includeXCoordinate(aBounds.getGreaterX());
        this.includeYCoordinate(aBounds.getLesserY());
        this.includeYCoordinate(aBounds.getGreaterY());
    }

    public void includeRectangle2D(Rectangle2D aRectangle2D) {
        this.includeXCoordinate(aRectangle2D.getMinX());
        this.includeXCoordinate(aRectangle2D.getMaxX());
        this.includeYCoordinate(aRectangle2D.getMinY());
        this.includeYCoordinate(aRectangle2D.getMaxY());
    }

    public void intersect(Bounds aBounds) {
        this._dX1 = Math.max(this._dX1, aBounds.getLesserX());
        this._dY1 = Math.max(this._dY1, aBounds.getLesserY());
        this._dX2 = Math.min(this._dX2, aBounds.getGreaterX());
        this._dY2 = Math.min(this._dY2, aBounds.getGreaterY());
        if (this._dX1 > this._dX2) {
            this._dX1 = this._dX2;
        }
        if (this._dY1 > this._dY2) {
            this._dY1 = this._dY2;
        }
    }

    public boolean intersectsPoint(double x, double y) {
        return this._dX1 <= x && x <= this._dX2 && this._dY1 <= y && y <= this._dY2;
    }

    public boolean intersectsPoint(Point2D aPoint2D) {
        return this.intersectsPoint(aPoint2D.getX(), aPoint2D.getY());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        if (this.intersectsPoint(x1, y1)) {
            return true;
        }
        if (this.intersectsPoint(x2, y2)) {
            return true;
        }
        if (x1 < this._dX1 && x2 < this._dX1) {
            return false;
        }
        if (x1 > this._dX2 && x2 > this._dX2) {
            return false;
        }
        if (y1 < this._dY1 && y2 < this._dY1) {
            return false;
        }
        if (y1 > this._dY2 && y2 > this._dY2) {
            return false;
        }
        if (this._dX1 <= x1 && x1 <= this._dX2 && this._dX1 <= x2 && x2 <= this._dX2) {
            return true;
        }
        if (this._dY1 <= y1 && y1 <= this._dY2 && this._dY1 <= y2 && y2 <= this._dY2) {
            return true;
        }
        double dSlope = (y2 - y1) / (x2 - x1);
        double _dYIntersectionAtX1 = dSlope * (this._dX1 - x1) + y1;
        double _dYIntersectionAtX2 = dSlope * (this._dX2 - x1) + y1;
        double _dXIntersectionAtY1 = (this._dY1 - y1) / dSlope + x1;
        double _dXIntersectionAtY2 = (this._dY2 - y1) / dSlope + x1;
        return this.intersectsPoint(this._dX1, _dYIntersectionAtX1) || this.intersectsPoint(this._dX2, _dYIntersectionAtX2) || this.intersectsPoint(_dXIntersectionAtY1, this._dY1) || this.intersectsPoint(_dXIntersectionAtY2, this._dY2);
    }

    public boolean intersectsLine(Point2D onePoint2D, Point2D twoPoint2D) {
        return this.intersectsLine(onePoint2D.getX(), onePoint2D.getY(), twoPoint2D.getX(), twoPoint2D.getY());
    }

    public boolean intersectsBounds(Bounds aBounds) {
        double dLesserX = aBounds.getLesserX();
        double dGreaterX = aBounds.getGreaterX();
        double dLesserY = aBounds.getLesserY();
        double dGreaterY = aBounds.getGreaterY();
        if (dLesserX < this._dX1) {
            if (dLesserY < this._dY1) {
                return dGreaterX >= this._dX1 && dGreaterY >= this._dY1;
            }
            return dGreaterX >= this._dX1 && dLesserY <= this._dY2;
        }
        if (dLesserY < this._dY1) {
            return dLesserX <= this._dX2 && dGreaterY >= this._dY1;
        }
        return dLesserX <= this._dX2 && dLesserY <= this._dY2;
    }

    public boolean completelyContainsLine(double x1, double y1, double x2, double y2) {
        return this._dX1 > Math.min(x1, x2) && this._dX2 < Math.max(x1, x2) && this._dY1 > Math.min(y1, y2) && this._dY2 < Math.max(y1, y2);
    }

    public boolean isCompletelyInside(Bounds aBounds) {
        return this._dX1 > aBounds.getLesserX() && this._dX2 < aBounds.getGreaterX() && this._dY1 > aBounds.getLesserY() && this._dY2 < aBounds.getGreaterY();
    }

    public Point2D[] cropLine(double x1, double y1, double x2, double y2) {
        if (!this.intersectsLine(x1, y1, x2, y2)) {
            return null;
        }
        Point2D[] resultLine = new Point2D[2];
        Point2D.Double beginPoint2D = new Point2D.Double(x1, y1);
        Point2D.Double endPoint2D = new Point2D.Double(x2, y2);
        if (((Point2D)beginPoint2D).getX() == ((Point2D)endPoint2D).getX()) {
            if (((Point2D)beginPoint2D).getY() > this._dY2) {
                ((Point2D)beginPoint2D).setLocation(((Point2D)beginPoint2D).getX(), this._dY2);
            }
            if (((Point2D)endPoint2D).getY() > this._dY2) {
                ((Point2D)endPoint2D).setLocation(((Point2D)endPoint2D).getX(), this._dY2);
            }
            if (((Point2D)beginPoint2D).getY() < this._dY1) {
                ((Point2D)beginPoint2D).setLocation(((Point2D)beginPoint2D).getX(), this._dY1);
            }
            if (((Point2D)endPoint2D).getY() < this._dY1) {
                ((Point2D)endPoint2D).setLocation(((Point2D)endPoint2D).getX(), this._dY1);
            }
        } else if (((Point2D)beginPoint2D).getY() == ((Point2D)endPoint2D).getY()) {
            if (((Point2D)beginPoint2D).getX() > this._dX2) {
                ((Point2D)beginPoint2D).setLocation(this._dX2, ((Point2D)beginPoint2D).getY());
            }
            if (((Point2D)endPoint2D).getX() > this._dX2) {
                ((Point2D)endPoint2D).setLocation(this._dX2, ((Point2D)endPoint2D).getY());
            }
            if (((Point2D)beginPoint2D).getX() < this._dX1) {
                ((Point2D)beginPoint2D).setLocation(this._dX1, ((Point2D)beginPoint2D).getY());
            }
            if (((Point2D)endPoint2D).getX() < this._dX1) {
                ((Point2D)endPoint2D).setLocation(this._dX1, ((Point2D)endPoint2D).getY());
            }
        } else {
            double y;
            double x;
            double dSlope = (((Point2D)beginPoint2D).getY() - ((Point2D)endPoint2D).getY()) / (((Point2D)beginPoint2D).getX() - ((Point2D)endPoint2D).getX());
            if (!this.intersectsPoint(beginPoint2D)) {
                if (((Point2D)beginPoint2D).getY() > this._dY2 && (x = (this._dY2 - ((Point2D)beginPoint2D).getY()) / dSlope + ((Point2D)beginPoint2D).getX()) >= this._dX1 && x <= this._dX2) {
                    ((Point2D)beginPoint2D).setLocation(x, ((Point2D)beginPoint2D).getY());
                    ((Point2D)beginPoint2D).setLocation(((Point2D)beginPoint2D).getX(), this._dY2);
                }
                if (((Point2D)beginPoint2D).getY() < this._dY1 && (x = (this._dY1 - ((Point2D)beginPoint2D).getY()) / dSlope + ((Point2D)beginPoint2D).getX()) >= this._dX1 && x <= this._dX2) {
                    ((Point2D)beginPoint2D).setLocation(x, ((Point2D)beginPoint2D).getY());
                    ((Point2D)beginPoint2D).setLocation(((Point2D)beginPoint2D).getX(), this._dY1);
                }
                if (((Point2D)beginPoint2D).getX() > this._dX2 && (y = dSlope * (this._dX2 - ((Point2D)beginPoint2D).getX()) + ((Point2D)beginPoint2D).getY()) >= this._dY1 && y <= this._dY2) {
                    ((Point2D)beginPoint2D).setLocation(this._dX2, ((Point2D)beginPoint2D).getY());
                    ((Point2D)beginPoint2D).setLocation(((Point2D)beginPoint2D).getX(), y);
                }
                if (((Point2D)beginPoint2D).getX() < this._dX1 && (y = dSlope * (this._dX1 - ((Point2D)beginPoint2D).getX()) + ((Point2D)beginPoint2D).getY()) >= this._dY1 && y <= this._dY2) {
                    ((Point2D)beginPoint2D).setLocation(this._dX1, ((Point2D)beginPoint2D).getY());
                    ((Point2D)beginPoint2D).setLocation(((Point2D)beginPoint2D).getX(), y);
                }
            }
            if (!this.intersectsPoint(endPoint2D)) {
                if (((Point2D)endPoint2D).getY() > this._dY2 && (x = (this._dY2 - ((Point2D)beginPoint2D).getY()) / dSlope + ((Point2D)beginPoint2D).getX()) >= this._dX1 && x <= this._dX2) {
                    ((Point2D)endPoint2D).setLocation(x, ((Point2D)endPoint2D).getY());
                    ((Point2D)endPoint2D).setLocation(((Point2D)endPoint2D).getX(), this._dY2);
                }
                if (((Point2D)endPoint2D).getY() < this._dY1 && (x = (this._dY1 - ((Point2D)beginPoint2D).getY()) / dSlope + ((Point2D)beginPoint2D).getX()) >= this._dX1 && x <= this._dX2) {
                    ((Point2D)endPoint2D).setLocation(x, ((Point2D)endPoint2D).getY());
                    ((Point2D)endPoint2D).setLocation(((Point2D)endPoint2D).getX(), this._dY1);
                }
                if (((Point2D)endPoint2D).getX() > this._dX2 && (y = dSlope * (this._dX2 - ((Point2D)beginPoint2D).getX()) + ((Point2D)beginPoint2D).getY()) >= this._dY1 && y <= this._dY2) {
                    ((Point2D)endPoint2D).setLocation(this._dX2, ((Point2D)endPoint2D).getY());
                    ((Point2D)endPoint2D).setLocation(((Point2D)endPoint2D).getX(), y);
                }
                if (((Point2D)endPoint2D).getX() < this._dX1 && (y = dSlope * (this._dX1 - ((Point2D)beginPoint2D).getX()) + ((Point2D)beginPoint2D).getY()) >= this._dY1 && y <= this._dY2) {
                    ((Point2D)endPoint2D).setLocation(this._dX1, ((Point2D)endPoint2D).getY());
                    ((Point2D)endPoint2D).setLocation(((Point2D)endPoint2D).getX(), y);
                }
            }
        }
        resultLine[0] = beginPoint2D;
        resultLine[1] = endPoint2D;
        return resultLine;
    }

    public boolean equals(Object anObject) {
        if (anObject == null || !(anObject instanceof Bounds)) {
            return false;
        }
        Bounds aBounds = (Bounds)anObject;
        return this._dX1 == aBounds.getLesserX() && this._dX2 == aBounds.getGreaterX() && this._dY1 == aBounds.getLesserY() && this._dY2 == aBounds.getGreaterY();
    }

    public int hashCode() {
        double temp = Math.abs(this._dX1 + this._dX2 + this._dY1 + this._dY2);
        while (temp != 0.0 && temp < 1.0) {
            temp *= 4.0;
        }
        return (int)temp;
    }

    public String toString() {
        return String.valueOf(Double.toString(this._dX1)) + " " + Double.toString(this._dY1) + " " + Double.toString(this._dX2) + " " + Double.toString(this._dY2);
    }

    private double min(double x1, double x2, double x3) {
        return Math.min(Math.min(x1, x2), x3);
    }

    private double max(double x1, double x2, double x3) {
        return Math.max(Math.max(x1, x2), x3);
    }
}

