/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.test.util;

import java.awt.Point;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.test.JHDTestCase;
import org.jhotdraw.util.UndoableAdapter;

public class UndoableAdapterTest
extends JHDTestCase {
    private UndoableAdapter undoableadapter;

    public UndoableAdapterTest(String name) {
        super(name);
    }

    public UndoableAdapter createInstance() throws Exception {
        return new UndoableAdapter(this.getDrawingEditor().view());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.undoableadapter = this.createInstance();
    }

    protected void tearDown() throws Exception {
        this.undoableadapter = null;
        super.tearDown();
    }

    public void testUndo() throws Exception {
    }

    public void testRedo() throws Exception {
    }

    public void testSetIsUndoable() throws Exception {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] tests = blArray;
        int i = 0;
        while (i < tests.length) {
            this.undoableadapter.setUndoable(tests[i]);
            UndoableAdapterTest.assertEquals((boolean)tests[i], (boolean)this.undoableadapter.isUndoable());
            ++i;
        }
    }

    public void testSetIsRedoable() throws Exception {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] tests = blArray;
        int i = 0;
        while (i < tests.length) {
            this.undoableadapter.setRedoable(tests[i]);
            UndoableAdapterTest.assertEquals((boolean)tests[i], (boolean)this.undoableadapter.isRedoable());
            ++i;
        }
    }

    public void testSetGetAffectedFigures() throws Exception {
        FigureEnumeration[] tests = new FigureEnumeration[]{new SingleFigureEnumerator(new RectangleFigure(new Point(30, 30), new Point(60, 60)))};
        int i = 0;
        while (i < tests.length) {
            this.undoableadapter.setAffectedFigures(tests[i]);
            FigureEnumeration returned = this.undoableadapter.getAffectedFigures();
            tests[i].reset();
            while (returned.hasNextFigure()) {
                UndoableAdapterTest.assertTrue((boolean)tests[i].hasNextFigure());
                UndoableAdapterTest.assertEquals((Object)tests[i].nextFigure(), (Object)returned.nextFigure());
            }
            UndoableAdapterTest.assertFalse((boolean)tests[i].hasNextFigure());
            ++i;
        }
    }

    public void testSetNullAffectedFigures() throws Exception {
        FigureEnumeration original = this.undoableadapter.getAffectedFigures();
        try {
            this.undoableadapter.setAffectedFigures(null);
            UndoableAdapterTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetAffectedFiguresCount() throws Exception {
    }

    public void testRelease() throws Exception {
    }

    public void testGetDrawingView() throws Exception {
    }

    public void testVault() throws Exception {
    }
}

