/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.test.util;

import java.awt.Point;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.test.JHDTestCase;
import org.jhotdraw.util.UndoRedoActivity;

public class UndoRedoActivityTest
extends JHDTestCase {
    private UndoRedoActivity undoredoactivity;

    public UndoRedoActivityTest(String name) {
        super(name);
    }

    public UndoRedoActivity createInstance() throws Exception {
        PasteCommand.UndoActivity undoActivity = new PasteCommand.UndoActivity(this.getDrawingEditor().view());
        undoActivity.setAffectedFigures(new SingleFigureEnumerator(new RectangleFigure(new Point(33, 33), new Point(44, 44))));
        return (UndoRedoActivity)UndoRedoActivity.createUndoRedoActivity(undoActivity);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.undoredoactivity = this.createInstance();
    }

    protected void tearDown() throws Exception {
        this.undoredoactivity = null;
        super.tearDown();
    }

    public void testUndo() throws Exception {
    }

    public void testRedo() throws Exception {
    }

    public void testSetIsUndoable() throws Exception {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] tests = blArray;
        int i = 0;
        while (i < tests.length) {
            this.undoredoactivity.setUndoable(tests[i]);
            UndoRedoActivityTest.assertEquals((boolean)tests[i], (boolean)this.undoredoactivity.isUndoable());
            ++i;
        }
    }

    public void testSetIsRedoable() throws Exception {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] tests = blArray;
        int i = 0;
        while (i < tests.length) {
            this.undoredoactivity.setRedoable(tests[i]);
            UndoRedoActivityTest.assertEquals((boolean)tests[i], (boolean)this.undoredoactivity.isRedoable());
            ++i;
        }
    }

    public void testSetGetAffectedFigures() throws Exception {
        FigureEnumeration[] tests = new FigureEnumeration[]{new SingleFigureEnumerator(new RectangleFigure(new Point(44, 44), new Point(55, 55)))};
        int i = 0;
        while (i < tests.length) {
            this.undoredoactivity.setAffectedFigures(tests[i]);
            FigureEnumeration returned = this.undoredoactivity.getAffectedFigures();
            tests[i].reset();
            while (returned.hasNextFigure()) {
                UndoRedoActivityTest.assertTrue((boolean)tests[i].hasNextFigure());
                UndoRedoActivityTest.assertEquals((Object)tests[i].nextFigure(), (Object)returned.nextFigure());
            }
            UndoRedoActivityTest.assertFalse((boolean)tests[i].hasNextFigure());
            ++i;
        }
    }

    public void testSetNullAffectedFigures() throws Exception {
        FigureEnumeration original = this.undoredoactivity.getAffectedFigures();
        try {
            this.undoredoactivity.setAffectedFigures(null);
            UndoRedoActivityTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetAffectedFiguresCount() throws Exception {
    }

    public void testGetDrawingView() throws Exception {
    }

    public void testRelease() throws Exception {
    }

    public void testGetReversedActivity() throws Exception {
    }

    public void testCreateUndoRedoActivity() throws Exception {
    }

    public void testVault() throws Exception {
    }
}

