/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureSelection;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class StandardFigureSelection
implements FigureSelection,
Serializable {
    private byte[] fData;
    public static final String TYPE = "org.jhotdraw.Figures";

    public StandardFigureSelection(FigureEnumeration fe, int figureCount) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        StorableOutput writer = new StorableOutput(output);
        writer.writeInt(figureCount);
        while (fe.hasNextFigure()) {
            writer.writeStorable(fe.nextFigure());
        }
        writer.close();
        this.fData = output.toByteArray();
    }

    public String getType() {
        return TYPE;
    }

    public Object getData(String type) {
        if (type.equals(TYPE)) {
            ByteArrayInputStream input = new ByteArrayInputStream(this.fData);
            List result = CollectionsFactory.current().createList(10);
            StorableInput reader = new StorableInput(input);
            int numRead = 0;
            try {
                int count = reader.readInt();
                while (numRead < count) {
                    Figure newFigure = (Figure)reader.readStorable();
                    result.add(newFigure);
                    ++numRead;
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
            return new FigureEnumerator(result);
        }
        return null;
    }

    public static FigureEnumeration duplicateFigures(FigureEnumeration toBeCloned, int figureCount) {
        StandardFigureSelection duplicater = new StandardFigureSelection(toBeCloned, figureCount);
        return (FigureEnumeration)duplicater.getData(duplicater.getType());
    }
}

