/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.Hashtable;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class SendToBackCommand
extends AbstractCommand {
    public SendToBackCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionZOrdered());
        FigureEnumeration fe = this.getUndoActivity().getAffectedFigures();
        while (fe.hasNextFigure()) {
            this.view().drawing().sendToBack(fe.nextFigure());
        }
        this.view().checkDamage();
    }

    protected boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Hashtable myOriginalLayers = new Hashtable();

        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                int currentFigureLayer = this.getOriginalLayer(currentFigure);
                this.getDrawingView().drawing().sendToLayer(currentFigure, currentFigureLayer);
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                this.sendToCommand(fe.nextFigure());
            }
            return true;
        }

        protected void sendToCommand(Figure f) {
            this.getDrawingView().drawing().sendToBack(f);
        }

        protected void addOriginalLayer(Figure affectedFigure, int newOriginalLayer) {
            this.myOriginalLayers.put(affectedFigure, new Integer(newOriginalLayer));
        }

        protected int getOriginalLayer(Figure lookupAffectedFigure) {
            return (Integer)this.myOriginalLayers.get(lookupAffectedFigure);
        }

        public void setAffectedFigures(FigureEnumeration fe) {
            super.setAffectedFigures(fe);
            FigureEnumeration copyFe = this.getAffectedFigures();
            while (copyFe.hasNextFigure()) {
                Figure f = copyFe.nextFigure();
                int originalLayer = this.getDrawingView().drawing().getLayer(f);
                this.addOriginalLayer(f, originalLayer);
            }
        }
    }
}

