/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class SelectAllCommand
extends AbstractCommand {
    public SelectAllCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        this.view().addToSelectionAll(this.view().drawing().figures());
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        FigureEnumeration fe = this.view().drawing().figures();
        return fe.hasNextFigure() && fe.nextFigure() != null;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.getDrawingView().addToSelectionAll(this.getAffectedFigures());
            return true;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.getDrawingView().addToSelectionAll(this.getDrawingView().drawing().figures());
                return true;
            }
            return false;
        }
    }
}

