/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureSelection;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.FigureTransferCommand;
import org.jhotdraw.util.Clipboard;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class PasteCommand
extends FigureTransferCommand {
    public PasteCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        Point lastClick = this.view().lastClick();
        FigureSelection selection = (FigureSelection)Clipboard.getClipboard().getContents();
        if (selection != null) {
            this.setUndoActivity(this.createUndoActivity());
            this.getUndoActivity().setAffectedFigures((FigureEnumerator)selection.getData("org.jhotdraw.Figures"));
            if (!this.getUndoActivity().getAffectedFigures().hasNextFigure()) {
                this.setUndoActivity(null);
                return;
            }
            Rectangle r = this.getBounds(this.getUndoActivity().getAffectedFigures());
            this.view().clearSelection();
            FigureEnumeration fe = this.insertFigures(this.getUndoActivity().getAffectedFigures(), lastClick.x - r.x, lastClick.y - r.y);
            this.getUndoActivity().setAffectedFigures(fe);
            this.view().checkDamage();
        }
    }

    public boolean isExecutableWithView() {
        return Clipboard.getClipboard().getContents() != null;
    }

    private Rectangle getBounds(FigureEnumeration fe) {
        Rectangle r = fe.nextFigure().displayBox();
        while (fe.hasNextFigure()) {
            r.add(fe.nextFigure().displayBox());
        }
        return r;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            DeleteFromDrawingVisitor deleteVisitor = new DeleteFromDrawingVisitor(this.getDrawingView().drawing());
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                fe.nextFigure().visit(deleteVisitor);
            }
            this.getDrawingView().clearSelection();
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.setAffectedFigures(this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false));
            return true;
        }
    }
}

