/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.StandardFigureSelection;
import org.jhotdraw.util.Clipboard;

public abstract class FigureTransferCommand
extends AbstractCommand {
    protected FigureTransferCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    protected void deleteFigures(FigureEnumeration fe) {
        DeleteFromDrawingVisitor deleteVisitor = new DeleteFromDrawingVisitor(this.view().drawing());
        while (fe.hasNextFigure()) {
            fe.nextFigure().visit(deleteVisitor);
        }
        this.view().clearSelection();
    }

    protected void copyFigures(FigureEnumeration fe, int figureCount) {
        Clipboard.getClipboard().setContents(new StandardFigureSelection(fe, figureCount));
    }

    public FigureEnumeration insertFigures(FigureEnumeration fe, int dx, int dy) {
        return this.view().insertFigures(fe, dx, dy, false);
    }
}

