/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class DragTracker
extends AbstractTool {
    private Figure fAnchorFigure;
    private int fLastX;
    private int fLastY;
    private boolean fMoved = false;

    public DragTracker(DrawingEditor newDrawingEditor, Figure anchor) {
        super(newDrawingEditor);
        this.setAnchorFigure(anchor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.setLastMouseX(x);
        this.setLastMouseY(y);
        if (e.isShiftDown()) {
            this.getActiveView().toggleSelection(this.getAnchorFigure());
            this.setAnchorFigure(null);
        } else if (!this.getActiveView().isFigureSelected(this.getAnchorFigure())) {
            this.getActiveView().clearSelection();
            this.getActiveView().addToSelection(this.getAnchorFigure());
        }
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.getActiveView().selection());
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.setHasMoved(Math.abs(x - this.getAnchorX()) > 4 || Math.abs(y - this.getAnchorY()) > 4);
        if (this.hasMoved()) {
            FigureEnumeration figures = this.getUndoActivity().getAffectedFigures();
            while (figures.hasNextFigure()) {
                figures.nextFigure().moveBy(x - this.getLastMouseX(), y - this.getLastMouseY());
            }
        }
        this.setLastMouseX(x);
        this.setLastMouseY(y);
    }

    protected void setAnchorFigure(Figure newAnchorFigure) {
        this.fAnchorFigure = newAnchorFigure;
    }

    public Figure getAnchorFigure() {
        return this.fAnchorFigure;
    }

    protected void setLastMouseX(int newLastMouseX) {
        this.fLastX = newLastMouseX;
    }

    protected int getLastMouseX() {
        return this.fLastX;
    }

    protected void setLastMouseY(int newLastMouseY) {
        this.fLastY = newLastMouseY;
    }

    protected int getLastMouseY() {
        return this.fLastY;
    }

    public boolean hasMoved() {
        return this.fMoved;
    }

    protected void setHasMoved(boolean newMoved) {
        this.fMoved = newMoved;
    }

    public void activate() {
    }

    public void deactivate() {
        if (this.hasMoved()) {
            ((UndoActivity)this.getUndoActivity()).setBackupPoint(new Point(this.getLastMouseX(), this.getLastMouseY()));
        } else {
            this.setUndoActivity(null);
        }
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.getActiveView(), new Point(this.getLastMouseX(), this.getLastMouseY()));
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Point myOriginalPoint;
        private Point myBackupPoint;

        public UndoActivity(DrawingView newDrawingView, Point newOriginalPoint) {
            super(newDrawingView);
            this.setOriginalPoint(newOriginalPoint);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.moveAffectedFigures(this.getBackupPoint(), this.getOriginalPoint());
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.moveAffectedFigures(this.getOriginalPoint(), this.getBackupPoint());
            return true;
        }

        public void setBackupPoint(Point newBackupPoint) {
            this.myBackupPoint = newBackupPoint;
        }

        public Point getBackupPoint() {
            return this.myBackupPoint;
        }

        public void setOriginalPoint(Point newOriginalPoint) {
            this.myOriginalPoint = newOriginalPoint;
        }

        public Point getOriginalPoint() {
            return this.myOriginalPoint;
        }

        public void moveAffectedFigures(Point startPoint, Point endPoint) {
            FigureEnumeration figures = this.getAffectedFigures();
            while (figures.hasNextFigure()) {
                figures.nextFigure().moveBy(endPoint.x - startPoint.x, endPoint.y - startPoint.y);
            }
        }
    }
}

