/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractFigure;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class DecoratorFigure
extends AbstractFigure
implements FigureChangeListener {
    private Figure myDecoratedFigure;
    private static final long serialVersionUID = 8993011151564573288L;
    private int decoratorFigureSerializedDataVersion = 1;

    public DecoratorFigure() {
        this.initialize();
    }

    public DecoratorFigure(Figure figure) {
        this.initialize();
        this.decorate(figure);
    }

    protected void initialize() {
    }

    public Insets connectionInsets() {
        return this.getDecoratedFigure().connectionInsets();
    }

    public boolean canConnect() {
        return this.getDecoratedFigure().canConnect();
    }

    public boolean containsPoint(int x, int y) {
        return this.getDecoratedFigure().containsPoint(x, y);
    }

    public void decorate(Figure figure) {
        this.setDecoratedFigure(figure);
        this.getDecoratedFigure().addToContainer(this);
    }

    public Figure peelDecoration() {
        this.getDecoratedFigure().removeFromContainer(this);
        this.removeDependendFigure(this.getDecoratedFigure());
        return this.getDecoratedFigure();
    }

    public void setDecoratedFigure(Figure newDecoratedFigure) {
        this.myDecoratedFigure = newDecoratedFigure;
    }

    public Figure getDecoratedFigure() {
        return this.myDecoratedFigure;
    }

    public Rectangle displayBox() {
        return this.getDecoratedFigure().displayBox();
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.getDecoratedFigure().basicDisplayBox(origin, corner);
    }

    public void draw(Graphics g) {
        this.getDecoratedFigure().draw(g);
    }

    public Figure findFigureInside(int x, int y) {
        Figure foundFigure = this.getDecoratedFigure().findFigureInside(x, y);
        if (foundFigure != null && foundFigure == this.getDecoratedFigure()) {
            return this;
        }
        return foundFigure;
    }

    public HandleEnumeration handles() {
        return this.getDecoratedFigure().handles();
    }

    public boolean includes(Figure figure) {
        return super.includes(figure) || this.getDecoratedFigure().includes(figure);
    }

    public void moveBy(int x, int y) {
        this.getDecoratedFigure().moveBy(x, y);
    }

    protected void basicMoveBy(int x, int y) {
    }

    public void release() {
        super.release();
        this.getDecoratedFigure().removeFromContainer(this);
        this.getDecoratedFigure().release();
    }

    public void figureInvalidated(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(e);
        }
    }

    public void figureChanged(FigureChangeEvent e) {
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(e);
        }
    }

    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public FigureEnumeration figures() {
        return this.getDecoratedFigure().figures();
    }

    public FigureEnumeration decompose() {
        return this.getDecoratedFigure().decompose();
    }

    public void setAttribute(String name, Object value) {
        this.getDecoratedFigure().setAttribute(name, value);
    }

    public void setAttribute(FigureAttributeConstant attributeConstant, Object value) {
        this.getDecoratedFigure().setAttribute(attributeConstant, value);
    }

    public Object getAttribute(String name) {
        return this.getDecoratedFigure().getAttribute(name);
    }

    public Object getAttribute(FigureAttributeConstant attributeConstant) {
        return this.getDecoratedFigure().getAttribute(attributeConstant);
    }

    public Locator connectedTextLocator(Figure text) {
        return this.getDecoratedFigure().connectedTextLocator(text);
    }

    public Connector connectorAt(int x, int y) {
        return this.getDecoratedFigure().connectorAt(x, y);
    }

    public void connectorVisibility(boolean isVisible, ConnectionFigure courtingConnection) {
        this.getDecoratedFigure().connectorVisibility(isVisible, null);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getDecoratedFigure());
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.decorate((Figure)dr.readStorable());
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.getDecoratedFigure().addToContainer(this);
    }

    public TextHolder getTextHolder() {
        return this.getDecoratedFigure().getTextHolder();
    }

    public synchronized FigureEnumeration getDependendFigures() {
        return this.getDecoratedFigure().getDependendFigures();
    }

    public synchronized void addDependendFigure(Figure newDependendFigure) {
        this.getDecoratedFigure().addDependendFigure(newDependendFigure);
    }

    public synchronized void removeDependendFigure(Figure oldDependendFigure) {
        this.getDecoratedFigure().removeDependendFigure(oldDependendFigure);
    }
}

