/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.List;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.FigureTransferCommand;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class CutCommand
extends FigureTransferCommand {
    public CutCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        FigureEnumeration fe = this.view().selection();
        List affected = CollectionsFactory.current().createList();
        while (fe.hasNextFigure()) {
            Figure f = fe.nextFigure();
            affected.add(0, f);
            FigureEnumeration dfe = f.getDependendFigures();
            if (dfe == null) continue;
            while (dfe.hasNextFigure()) {
                affected.add(0, dfe.nextFigure());
            }
        }
        fe = new FigureEnumerator(affected);
        this.getUndoActivity().setAffectedFigures(fe);
        UndoActivity ua = (UndoActivity)this.getUndoActivity();
        ua.setSelectedFigures(this.view().selection());
        this.copyFigures(ua.getSelectedFigures(), ua.getSelectedFiguresCount());
        this.deleteFigures(this.getUndoActivity().getAffectedFigures());
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private FigureTransferCommand myCommand;
        private List mySelectedFigures;

        public UndoActivity(FigureTransferCommand newCommand) {
            super(newCommand.view());
            this.myCommand = newCommand;
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (super.undo() && this.getAffectedFigures().hasNextFigure()) {
                this.getDrawingView().clearSelection();
                this.myCommand.insertFigures(this.getAffectedFiguresReversed(), 0, 0);
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.myCommand.copyFigures(this.getSelectedFigures(), this.getSelectedFiguresCount());
                this.myCommand.deleteFigures(this.getAffectedFigures());
                return true;
            }
            return false;
        }

        public void setSelectedFigures(FigureEnumeration newSelectedFigures) {
            this.rememberSelectedFigures(newSelectedFigures);
        }

        protected void rememberSelectedFigures(FigureEnumeration toBeRemembered) {
            this.mySelectedFigures = CollectionsFactory.current().createList();
            while (toBeRemembered.hasNextFigure()) {
                this.mySelectedFigures.add(toBeRemembered.nextFigure());
            }
        }

        public FigureEnumeration getSelectedFigures() {
            return new FigureEnumerator(CollectionsFactory.current().createList(this.mySelectedFigures));
        }

        public int getSelectedFiguresCount() {
            return this.mySelectedFigures.size();
        }

        public void release() {
            super.release();
            FigureEnumeration fe = this.getSelectedFigures();
            while (fe.hasNextFigure()) {
                fe.nextFigure().release();
            }
            this.setSelectedFigures(FigureEnumerator.getEmptyEnumeration());
        }
    }
}

