/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Cursor;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.standard.LocatorHandle;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure myConnection;
    private ConnectionFigure fPrototype;
    private Figure myTargetFigure;

    public ConnectionHandle(Figure owner, Locator l, ConnectionFigure prototype) {
        super(owner, l);
        this.fPrototype = prototype;
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setConnection(this.createConnection());
        this.setUndoActivity(this.createUndoActivity(view));
        List connectionsList = CollectionsFactory.current().createList();
        connectionsList.add(this.getConnection());
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(connectionsList));
        Point p = this.locate();
        this.getConnection().startPoint(p.x, p.y);
        this.getConnection().endPoint(p.x, p.y);
        view.drawing().add(this.getConnection());
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = this.findConnectableFigure(x, y, view.drawing());
        if (f != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false, null);
            }
            this.setTargetFigure(f);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true, this.getConnection());
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        }
        this.getConnection().endPoint(p.x, p.y);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target != null) {
            this.getConnection().connectStart(this.startConnector());
            this.getConnection().connectEnd(target);
            this.getConnection().updateConnection();
        } else {
            view.drawing().remove(this.getConnection());
            this.setUndoActivity(null);
        }
        this.setConnection(null);
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false, null);
            this.setTargetFigure(null);
        }
    }

    private Connector startConnector() {
        Point p = this.locate();
        return this.owner().connectorAt(p.x, p.y);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Undoable createUndoActivity(DrawingView view) {
        return new PasteCommand.UndoActivity(view);
    }

    protected Connector findConnectionTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect() && !target.includes(this.owner()) && this.getConnection().canConnect(this.owner(), target)) {
            return this.findConnector(x, y, target);
        }
        return null;
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration fe = drawing.figuresReverse();
        while (fe.hasNextFigure()) {
            Figure figure = fe.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.myConnection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected Figure getTargetFigure() {
        return this.myTargetFigure;
    }

    protected void setTargetFigure(Figure newTargetFigure) {
        this.myTargetFigure = newTargetFigure;
    }

    public Cursor getCursor() {
        return new AWTCursor(12);
    }
}

