/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Graphics;
import java.awt.Point;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.ChangeConnectionHandle;
import org.jhotdraw.standard.OffsetConnector;
import org.jhotdraw.util.Undoable;

public class ChangeConnectionEndHandle
extends ChangeConnectionHandle {
    public ChangeConnectionEndHandle(ConnectionFigure owner) {
        super(owner);
    }

    protected Connector target() {
        return this.getConnection().getEndConnector();
    }

    protected void disconnect() {
        this.getConnection().disconnectEnd();
    }

    protected void connect(Connector c) {
        this.getConnection().connectEnd(c);
    }

    protected void setPoint(int x, int y) {
        this.getConnection().endPoint(x, y);
    }

    public Point locate() {
        return this.getConnection().endPoint();
    }

    public void draw(Graphics g) {
        if (this.getConnection().getEndConnector() instanceof OffsetConnector && this.getConnection().getStartConnector() != null && this.getConnection().getStartConnector().owner() != null && this.getConnection().getStartConnector().owner() == this.getConnection().getEndConnector().owner()) {
            return;
        }
        super.draw(g);
    }

    protected Undoable createUndoActivity(DrawingView newView) {
        return new UndoActivity(newView);
    }

    protected boolean canConnectTo(Figure figure) {
        return this.getConnection().canConnect(this.source().owner(), figure);
    }

    public static class UndoActivity
    extends ChangeConnectionHandle.UndoActivity {
        public UndoActivity(DrawingView newView) {
            super(newView);
        }

        protected Connector replaceConnector(ConnectionFigure connection) {
            Connector tempEndConnector = connection.getEndConnector();
            connection.connectEnd(this.getOldConnector());
            return tempEndConnector;
        }
    }
}

