/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ToolListener;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.standard.AWTCursor;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;

public abstract class AbstractTool
implements Tool {
    private DrawingEditor myDrawingEditor;
    private int myAnchorX;
    private int myAnchorY;
    private DrawingView myDrawingView;
    private Undoable myUndoActivity;
    private EventDispatcher myEventDispatcher;
    private boolean myIsUsable;
    private boolean myIsEnabled;

    public AbstractTool(DrawingEditor newDrawingEditor) {
        this.setEditor(newDrawingEditor);
        this.setEventDispatcher(this.createEventDispatcher());
        this.setEnabled(true);
        this.checkUsable();
        this.editor().addViewChangeListener(this.createViewChangeListener());
    }

    public void activate() {
        if (this.getActiveView() != null) {
            this.getActiveView().clearSelection();
            this.getActiveView().checkDamage();
            this.getEventDispatcher().fireToolActivatedEvent();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            if (this.getActiveView() != null) {
                this.getActiveView().setCursor(new AWTCursor(0));
            }
            this.getEventDispatcher().fireToolDeactivatedEvent();
        }
    }

    protected void viewSelectionChanged(DrawingView oldView, DrawingView newView) {
        if (this.isActive()) {
            this.deactivate();
            this.activate();
        }
        this.checkUsable();
    }

    protected void viewCreated(DrawingView view) {
    }

    protected void viewDestroying(DrawingView view) {
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setAnchorX(x);
        this.setAnchorY(y);
        this.setView((DrawingView)e.getSource());
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
    }

    public void mouseMove(MouseEvent evt, int x, int y) {
    }

    public void keyDown(KeyEvent evt, int key) {
    }

    public Drawing drawing() {
        return this.view().drawing();
    }

    public Drawing getActiveDrawing() {
        return this.getActiveView().drawing();
    }

    public DrawingEditor editor() {
        return this.myDrawingEditor;
    }

    protected void setEditor(DrawingEditor newDrawingEditor) {
        this.myDrawingEditor = newDrawingEditor;
    }

    public DrawingView view() {
        return this.myDrawingView;
    }

    protected void setView(DrawingView newDrawingView) {
        this.myDrawingView = newDrawingView;
    }

    public DrawingView getActiveView() {
        return this.editor().view();
    }

    public boolean isUsable() {
        return this.isEnabled() && this.myIsUsable;
    }

    public void setUsable(boolean newIsUsable) {
        if (this.isUsable() != newIsUsable) {
            this.myIsUsable = newIsUsable;
            if (this.isUsable()) {
                this.getEventDispatcher().fireToolUsableEvent();
            } else {
                this.getEventDispatcher().fireToolUnusableEvent();
            }
        }
    }

    public void setEnabled(boolean newIsEnabled) {
        if (this.isEnabled() != newIsEnabled) {
            this.myIsEnabled = newIsEnabled;
            if (this.isEnabled()) {
                this.getEventDispatcher().fireToolEnabledEvent();
            } else {
                this.getEventDispatcher().fireToolDisabledEvent();
                this.setUsable(false);
                this.deactivate();
            }
        }
    }

    public boolean isEnabled() {
        return this.myIsEnabled;
    }

    protected void setAnchorX(int newAnchorX) {
        this.myAnchorX = newAnchorX;
    }

    protected int getAnchorX() {
        return this.myAnchorX;
    }

    protected void setAnchorY(int newAnchorY) {
        this.myAnchorY = newAnchorY;
    }

    protected int getAnchorY() {
        return this.myAnchorY;
    }

    public Undoable getUndoActivity() {
        return this.myUndoActivity;
    }

    public void setUndoActivity(Undoable newUndoActivity) {
        this.myUndoActivity = newUndoActivity;
    }

    public boolean isActive() {
        return this.editor().tool() == this && this.isUsable();
    }

    public void addToolListener(ToolListener newToolListener) {
        this.getEventDispatcher().addToolListener(newToolListener);
    }

    public void removeToolListener(ToolListener oldToolListener) {
        this.getEventDispatcher().removeToolListener(oldToolListener);
    }

    private void setEventDispatcher(EventDispatcher newEventDispatcher) {
        this.myEventDispatcher = newEventDispatcher;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected EventDispatcher createEventDispatcher() {
        return new EventDispatcher(this);
    }

    protected ViewChangeListener createViewChangeListener() {
        return new ViewChangeListener(){

            public void viewSelectionChanged(DrawingView oldView, DrawingView newView) {
                AbstractTool.this.viewSelectionChanged(oldView, newView);
            }

            public void viewCreated(DrawingView view) {
                AbstractTool.this.viewCreated(view);
            }

            public void viewDestroying(DrawingView view) {
                AbstractTool.this.viewDestroying(view);
            }
        };
    }

    protected void checkUsable() {
        if (this.isEnabled()) {
            this.setUsable(this.getActiveView() != null && this.getActiveView().isInteractive());
        }
    }

    public static class EventDispatcher {
        private List myRegisteredListeners = CollectionsFactory.current().createList();
        private Tool myObservedTool;

        public EventDispatcher(Tool newObservedTool) {
            this.myObservedTool = newObservedTool;
        }

        public void fireToolUsableEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolUsable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolUnusableEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolUnusable(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolActivatedEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolActivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDeactivatedEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolDeactivated(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolEnabledEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolEnabled(new EventObject(this.myObservedTool));
            }
        }

        public void fireToolDisabledEvent() {
            Iterator iter = this.myRegisteredListeners.iterator();
            while (iter.hasNext()) {
                ((ToolListener)iter.next()).toolDisabled(new EventObject(this.myObservedTool));
            }
        }

        public void addToolListener(ToolListener newToolListener) {
            if (!this.myRegisteredListeners.contains(newToolListener)) {
                this.myRegisteredListeners.add(newToolListener);
            }
        }

        public void removeToolListener(ToolListener oldToolListener) {
            if (this.myRegisteredListeners.contains(oldToolListener)) {
                this.myRegisteredListeners.remove(oldToolListener);
            }
        }
    }
}

