/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class AbstractConnector
implements Connector {
    protected Figure fOwner;
    private static final long serialVersionUID = -5170007865562687545L;
    private int abstractConnectorSerializedDataVersion = 1;

    public AbstractConnector() {
        this.fOwner = null;
    }

    public AbstractConnector(Figure owner) {
        this.fOwner = owner;
    }

    public Figure owner() {
        return this.fOwner;
    }

    public Point findStart(ConnectionFigure connection) {
        return this.findPoint(connection);
    }

    public Point findEnd(ConnectionFigure connection) {
        return this.findPoint(connection);
    }

    protected Point findPoint(ConnectionFigure connection) {
        return Geom.center(this.displayBox());
    }

    public Rectangle displayBox() {
        return this.owner().displayBox();
    }

    public boolean containsPoint(int x, int y) {
        return this.owner().containsPoint(x, y);
    }

    public void draw(Graphics g) {
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.owner());
    }

    public void read(StorableInput dr) throws IOException {
        try {
            this.fOwner = (Figure)dr.readStorable();
        }
        catch (ClassCastException ex) {
            Storable o = dr.readStorable();
            System.out.println("Class Cast Exception " + o.toString());
        }
    }

    public void connectorVisibility(boolean isVisible, ConnectionFigure courtingConnection) {
    }

    public Point connectorMovedTo(int x, int y) {
        return new Point(x, y);
    }

    public Connector finalizeConnector(boolean start) {
        return this;
    }
}

