/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.figures.NumberTextFigure;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.samples.pert.PertDependency;
import org.jhotdraw.standard.CompositeFigure;
import org.jhotdraw.standard.ConnectionHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class PertFigure
extends CompositeFigure {
    private static final int BORDER = 3;
    private Rectangle fDisplayBox;
    private List fPreTasks;
    private List fPostTasks;
    private static final long serialVersionUID = -7877776240236946511L;
    private int pertFigureSerializedDataVersion = 1;

    public PertFigure() {
        this.initialize();
    }

    public int start() {
        int start = 0;
        for (PertFigure f : this.fPreTasks) {
            start = Math.max(start, f.end());
        }
        return start;
    }

    public int end() {
        return this.asInt(2);
    }

    public int duration() {
        return this.asInt(1);
    }

    public void setEnd(int value) {
        this.setInt(2, value);
    }

    public void addPreTask(PertFigure figure) {
        if (!this.fPreTasks.contains(figure)) {
            this.fPreTasks.add(figure);
        }
    }

    public void addPostTask(PertFigure figure) {
        if (!this.fPostTasks.contains(figure)) {
            this.fPostTasks.add(figure);
        }
    }

    public void removePreTask(PertFigure figure) {
        this.fPreTasks.remove(figure);
    }

    public void removePostTask(PertFigure figure) {
        this.fPostTasks.remove(figure);
    }

    private int asInt(int figureIndex) {
        NumberTextFigure t = (NumberTextFigure)this.figureAt(figureIndex);
        return t.getValue();
    }

    private String taskName() {
        TextFigure t = (TextFigure)this.figureAt(0);
        return t.getText();
    }

    private void setInt(int figureIndex, int value) {
        NumberTextFigure t = (NumberTextFigure)this.figureAt(figureIndex);
        t.setValue(value);
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
        super.basicMoveBy(x, y);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
        this.layout();
    }

    private void drawBorder(Graphics g) {
        super.draw(g);
        Rectangle r = this.displayBox();
        Figure f = this.figureAt(0);
        Rectangle rf = f.displayBox();
        g.setColor(Color.gray);
        g.drawLine(r.x, r.y + rf.height + 2, r.x + r.width, r.y + rf.height + 2);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y + rf.height + 3, r.x + r.width, r.y + rf.height + 3);
        g.setColor(Color.white);
        g.drawLine(r.x, r.y, r.x, r.y + r.height);
        g.drawLine(r.x, r.y, r.x + r.width, r.y);
        g.setColor(Color.gray);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + r.width, r.y + r.height);
    }

    public void draw(Graphics g) {
        this.drawBorder(g);
        super.draw(g);
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        handles.add(new NullHandle(this, RelativeLocator.northWest()));
        handles.add(new NullHandle(this, RelativeLocator.northEast()));
        handles.add(new NullHandle(this, RelativeLocator.southWest()));
        handles.add(new NullHandle(this, RelativeLocator.southEast()));
        handles.add(new ConnectionHandle(this, RelativeLocator.east(), new PertDependency()));
        return new HandleEnumerator(handles);
    }

    private void initialize() {
        this.fPostTasks = CollectionsFactory.current().createList();
        this.fPreTasks = CollectionsFactory.current().createList();
        this.fDisplayBox = new Rectangle(0, 0, 0, 0);
        Font f = new Font("Helvetica", 0, 12);
        Font fb = new Font("Helvetica", 1, 12);
        TextFigure name = new TextFigure();
        name.setFont(fb);
        name.setText("Task");
        this.add(name);
        NumberTextFigure duration = new NumberTextFigure();
        duration.setValue(0);
        duration.setFont(fb);
        this.add(duration);
        NumberTextFigure end = new NumberTextFigure();
        end.setValue(0);
        end.setFont(f);
        end.setReadOnly(true);
        this.add(end);
    }

    private void layout() {
        Point partOrigin = new Point(this.fDisplayBox.x, this.fDisplayBox.y);
        partOrigin.translate(3, 3);
        Dimension extent = new Dimension(0, 0);
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            Figure f = fe.nextFigure();
            Dimension partExtent = f.size();
            Point corner = new Point(partOrigin.x + partExtent.width, partOrigin.y + partExtent.height);
            f.basicDisplayBox(partOrigin, corner);
            extent.width = Math.max(extent.width, partExtent.width);
            extent.height += partExtent.height;
            partOrigin.y += partExtent.height;
        }
        this.fDisplayBox.width = extent.width + 6;
        this.fDisplayBox.height = extent.height + 6;
    }

    private boolean needsLayout() {
        Dimension extent = new Dimension(0, 0);
        FigureEnumeration fe = this.figures();
        while (fe.hasNextFigure()) {
            Figure f = fe.nextFigure();
            extent.width = Math.max(extent.width, f.size().width);
        }
        int newExtent = extent.width + 6;
        return newExtent != this.fDisplayBox.width;
    }

    public void update(FigureChangeEvent e) {
        if (e.getFigure() == this.figureAt(1)) {
            this.updateDurations();
        }
        if (this.needsLayout()) {
            this.layout();
            this.changed();
        }
    }

    public void figureChanged(FigureChangeEvent e) {
        this.update(e);
    }

    public void figureRemoved(FigureChangeEvent e) {
        this.update(e);
    }

    public void notifyPostTasks() {
        Iterator iter = this.fPostTasks.iterator();
        while (iter.hasNext()) {
            ((PertFigure)iter.next()).updateDurations();
        }
    }

    public void updateDurations() {
        int newEnd = this.start() + this.duration();
        if (newEnd != this.end()) {
            this.setEnd(newEnd);
            this.notifyPostTasks();
        }
    }

    public boolean hasCycle(Figure start) {
        if (start == this) {
            return true;
        }
        Iterator iter = this.fPreTasks.iterator();
        while (iter.hasNext()) {
            if (!((PertFigure)iter.next()).hasCycle(start)) continue;
            return true;
        }
        return false;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        this.writeTasks(dw, this.fPreTasks);
        this.writeTasks(dw, this.fPostTasks);
    }

    public void writeTasks(StorableOutput dw, List l) {
        dw.writeInt(l.size());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            dw.writeStorable((Storable)iter.next());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.layout();
        this.fPreTasks = this.readTasks(dr);
        this.fPostTasks = this.readTasks(dr);
    }

    public Insets connectionInsets() {
        Rectangle r = this.fDisplayBox;
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    public List readTasks(StorableInput dr) throws IOException {
        int size = dr.readInt();
        List l = CollectionsFactory.current().createList(size);
        int i = 0;
        while (i < size) {
            l.add(dr.readStorable());
            ++i;
        }
        return l;
    }
}

