/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.BorderLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JApplet;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.samples.javadraw.FollowURLTool;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.UndoManager;

public class JavaDrawViewer
extends JApplet
implements DrawingEditor {
    private Drawing fDrawing;
    private Tool fTool;
    private StandardDrawingView fView;
    private transient UndoManager myUndoManager;

    public void init() {
        this.setUndoManager(new UndoManager());
        this.getContentPane().setLayout(new BorderLayout());
        this.fView = new StandardDrawingView(this, 400, 370);
        this.getContentPane().add("Center", this.fView);
        this.setTool(new FollowURLTool(this, this));
        String filename = this.getParameter("Drawing");
        if (filename != null) {
            this.loadDrawing(filename);
            this.fView.setDrawing(this.fDrawing);
        } else {
            this.showStatus("Unable to load drawing");
        }
    }

    public void addViewChangeListener(ViewChangeListener vsl) {
    }

    public void removeViewChangeListener(ViewChangeListener vsl) {
    }

    private void loadDrawing(String filename) {
        try {
            URL url = new URL(this.getCodeBase(), filename);
            InputStream stream = url.openStream();
            StorableInput reader = new StorableInput(stream);
            this.fDrawing = (Drawing)reader.readStorable();
        }
        catch (IOException e) {
            this.fDrawing = this.createDrawing();
            System.err.println("Error when Loading: " + e);
            this.showStatus("Error when Loading: " + e);
        }
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    public DrawingView view() {
        return this.fView;
    }

    public DrawingView[] views() {
        return new DrawingView[]{this.view()};
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public void setTool(Tool newTool) {
        this.fTool = newTool;
    }

    public void toolDone() {
    }

    public void figureSelectionChanged(DrawingView view) {
    }

    protected void setUndoManager(UndoManager newUndoManager) {
        this.myUndoManager = newUndoManager;
    }

    public UndoManager getUndoManager() {
        return this.myUndoManager;
    }
}

