/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import org.jhotdraw.application.DrawApplication;
import org.jhotdraw.contrib.ClippingUpdateStrategy;
import org.jhotdraw.contrib.ComponentFigure;
import org.jhotdraw.contrib.CompositeFigureCreationTool;
import org.jhotdraw.contrib.DiamondFigure;
import org.jhotdraw.contrib.GraphicalCompositeFigure;
import org.jhotdraw.contrib.MDIDesktopPane;
import org.jhotdraw.contrib.MDI_DrawApplication;
import org.jhotdraw.contrib.PolygonTool;
import org.jhotdraw.contrib.SimpleLayouter;
import org.jhotdraw.contrib.SplitConnectionTool;
import org.jhotdraw.contrib.TextAreaFigure;
import org.jhotdraw.contrib.TextAreaTool;
import org.jhotdraw.contrib.TriangleFigure;
import org.jhotdraw.contrib.WindowMenu;
import org.jhotdraw.contrib.html.HTMLTextAreaFigure;
import org.jhotdraw.contrib.html.HTMLTextAreaTool;
import org.jhotdraw.contrib.zoom.ZoomDrawingView;
import org.jhotdraw.contrib.zoom.ZoomTool;
import org.jhotdraw.figures.BorderTool;
import org.jhotdraw.figures.ConnectedTextTool;
import org.jhotdraw.figures.ElbowConnection;
import org.jhotdraw.figures.EllipseFigure;
import org.jhotdraw.figures.InsertImageCommand;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.LineFigure;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.figures.RoundRectangleFigure;
import org.jhotdraw.figures.ScribbleTool;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.figures.TextTool;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.samples.javadraw.Animator;
import org.jhotdraw.samples.javadraw.BouncingDrawing;
import org.jhotdraw.samples.javadraw.MySelectionTool;
import org.jhotdraw.samples.javadraw.URLTool;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.ConnectionTool;
import org.jhotdraw.standard.CreationTool;
import org.jhotdraw.util.Animatable;
import org.jhotdraw.util.CommandMenu;
import org.jhotdraw.util.UndoableCommand;
import org.jhotdraw.util.UndoableTool;

public class JavaDrawApp
extends MDI_DrawApplication {
    private Animator fAnimator;
    private static String fgSampleImagesPath = "/org/jhotdraw/samples/javadraw/sampleimages";
    private static String fgSampleImagesResourcePath = String.valueOf(fgSampleImagesPath) + "/";

    JavaDrawApp() {
        super("JHotDraw");
    }

    public JavaDrawApp(String title) {
        super(title);
    }

    protected DrawApplication createApplication() {
        return new JavaDrawApp();
    }

    protected DrawingView createDrawingView(Drawing newDrawing) {
        Dimension d = this.getDrawingViewSize();
        ZoomDrawingView newDrawingView = new ZoomDrawingView(this, d.width, d.height);
        newDrawingView.setDrawing(newDrawing);
        return newDrawingView;
    }

    public void destroy() {
        super.destroy();
        this.endAnimation();
    }

    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        Tool tool = new ZoomTool(this);
        palette.add(this.createToolButton("/org/jhotdraw/images/ZOOM", "Zoom Tool", tool));
        tool = new UndoableTool(new TextTool(this, new TextFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/TEXT", "Text Tool", tool));
        tool = new UndoableTool(new ConnectedTextTool(this, new TextFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/ATEXT", "Connected Text Tool", tool));
        tool = new URLTool(this);
        palette.add(this.createToolButton("/org/jhotdraw/images/URL", "URL Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new RectangleFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/RECT", "Rectangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new RoundRectangleFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/RRECT", "Round Rectangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new EllipseFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/ELLIPSE", "Ellipse Tool", tool));
        tool = new UndoableTool(new PolygonTool(this));
        palette.add(this.createToolButton("/org/jhotdraw/images/POLYGON", "Polygon Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new TriangleFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/TRIANGLE", "Triangle Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new DiamondFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/DIAMOND", "Diamond Tool", tool));
        tool = new UndoableTool(new CreationTool(this, new LineFigure()));
        palette.add(this.createToolButton("/org/jhotdraw/images/LINE", "Line Tool", tool));
        tool = new UndoableTool(new ConnectionTool(this, new LineConnection()));
        palette.add(this.createToolButton("/org/jhotdraw/images/CONN", "Connection Tool", tool));
        tool = new UndoableTool(new ConnectionTool(this, new ElbowConnection()));
        palette.add(this.createToolButton("/org/jhotdraw/images/OCONN", "Elbow Connection Tool", tool));
        tool = new UndoableTool(new ScribbleTool(this));
        palette.add(this.createToolButton("/org/jhotdraw/images/SCRIBBL", "Scribble Tool", tool));
        tool = new UndoableTool(new BorderTool(this));
        palette.add(this.createToolButton("/org/jhotdraw/images/BORDDEC", "Border Tool", tool));
        JButton button = new JButton("Hello World");
        tool = new CreationTool(this, new ComponentFigure(button));
        palette.add(this.createToolButton("/org/jhotdraw/images/RECT", "Component Tool", tool));
        tool = new TextAreaTool(this, new TextAreaFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/TEXTAREA", "TextArea Tool", tool));
        GraphicalCompositeFigure fig = new GraphicalCompositeFigure();
        fig.setLayouter(new SimpleLayouter(fig));
        tool = new CreationTool(this, fig);
        palette.add(this.createToolButton("/org/jhotdraw/images/RECT", "Container Figure Tool", tool));
        tool = new CompositeFigureCreationTool(this, new RectangleFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/RECT", "Nested Figure Tool", tool));
        tool = new HTMLTextAreaTool(this, new HTMLTextAreaFigure());
        palette.add(this.createToolButton("/org/jhotdraw/images/TEXTAREA", "HTML TextArea Tool", tool));
        LineConnection lineConnection = new LineConnection();
        lineConnection.setStartDecoration(null);
        tool = new UndoableTool(new SplitConnectionTool(this, lineConnection));
        palette.add(this.createToolButton("/org/jhotdraw/images/OCONN", "Split Connection Tool", tool));
    }

    protected Tool createSelectionTool() {
        return new MySelectionTool(this);
    }

    protected void createMenus(JMenuBar mb) {
        super.createMenus(mb);
        this.addMenuIfPossible(mb, this.createAnimationMenu());
        this.addMenuIfPossible(mb, this.createImagesMenu());
        this.addMenuIfPossible(mb, this.createWindowMenu());
    }

    protected JMenu createAnimationMenu() {
        CommandMenu menu = new CommandMenu("Animation");
        AbstractCommand cmd = new AbstractCommand("Start Animation", this){

            public void execute() {
                JavaDrawApp.this.startAnimation();
            }
        };
        menu.add(cmd);
        cmd = new AbstractCommand("Stop Animation", this){

            public void execute() {
                JavaDrawApp.this.endAnimation();
            }
        };
        menu.add(cmd);
        return menu;
    }

    protected JMenu createWindowMenu() {
        CommandMenu menu = new CommandMenu("Window");
        AbstractCommand cmd = new AbstractCommand("New View", this){

            public void execute() {
                JavaDrawApp.this.newView();
            }
        };
        menu.add(cmd);
        cmd = new AbstractCommand("New Window", this, false){

            public void execute() {
                JavaDrawApp.this.newWindow(JavaDrawApp.this.createDrawing());
            }
        };
        menu.add(cmd);
        menu.addSeparator();
        menu.add(new WindowMenu("Window List", (MDIDesktopPane)this.getDesktop(), this));
        return menu;
    }

    protected JMenu createImagesMenu() {
        CommandMenu menu = new CommandMenu("Images");
        URL url = this.getClass().getResource(fgSampleImagesPath);
        if (url == null) {
            throw new JHotDrawRuntimeException("Could not locate images: " + fgSampleImagesPath);
        }
        File imagesDirectory = new File(url.getFile());
        try {
            String[] list = imagesDirectory.list();
            int i = 0;
            while (i < list.length) {
                String name = list[i];
                String path = String.valueOf(fgSampleImagesResourcePath) + name;
                menu.add(new UndoableCommand(new InsertImageCommand(name, path, this)));
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return menu;
    }

    protected Drawing createDrawing() {
        BouncingDrawing dwg = new BouncingDrawing();
        dwg.setTitle(this.getDefaultDrawingTitle());
        return dwg;
    }

    public void startAnimation() {
        if (this.view().drawing() instanceof Animatable && this.fAnimator == null) {
            this.fAnimator = new Animator((Animatable)((Object)this.view().drawing()), this.view());
            this.fAnimator.start();
        }
    }

    public void endAnimation() {
        if (this.fAnimator != null) {
            this.fAnimator.end();
            this.fAnimator = null;
        }
    }

    protected JMenu createDebugMenu() {
        CommandMenu menu = (CommandMenu)super.createDebugMenu();
        AbstractCommand cmd = new AbstractCommand("Clipping Update", this){

            public void execute() {
                this.view().setDisplayUpdate(new ClippingUpdateStrategy());
            }
        };
        menu.add(cmd);
        return menu;
    }

    public static void main(String[] args) {
        JavaDrawApp window = new JavaDrawApp();
        window.open();
    }
}

