/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.standard.AbstractTool;

class FollowURLTool
extends AbstractTool {
    private JApplet fApplet;

    FollowURLTool(DrawingEditor newDrawingEditor, JApplet applet) {
        super(newDrawingEditor);
        this.fApplet = applet;
    }

    public void mouseMove(MouseEvent e, int x, int y) {
        String urlstring = null;
        Figure figure = this.drawing().findFigureInside(x, y);
        if (figure != null) {
            urlstring = (String)figure.getAttribute(FigureAttributeConstant.URL);
        }
        if (urlstring != null) {
            this.fApplet.showStatus(urlstring);
        } else {
            this.fApplet.showStatus("");
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        Figure figure = this.getActiveDrawing().findFigureInside(x, y);
        if (figure == null) {
            return;
        }
        String urlstring = (String)figure.getAttribute(FigureAttributeConstant.URL);
        if (urlstring == null) {
            return;
        }
        try {
            URL url = new URL(this.fApplet.getDocumentBase(), urlstring);
            this.fApplet.getAppletContext().showDocument(url);
        }
        catch (MalformedURLException exception) {
            this.fApplet.showStatus(exception.toString());
        }
    }
}

