/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.DecoratorFigure;
import org.jhotdraw.util.Animatable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class AnimationDecorator
extends DecoratorFigure
implements Animatable {
    private int fXVelocity;
    private int fYVelocity;
    private static final long serialVersionUID = 7894632974364110685L;
    private int animationDecoratorSerializedDataVersion = 1;

    public AnimationDecorator() {
    }

    public AnimationDecorator(Figure figure) {
        super(figure);
        this.fXVelocity = 4;
        this.fYVelocity = 4;
    }

    public void velocity(int xVelocity, int yVelocity) {
        this.fXVelocity = xVelocity;
        this.fYVelocity = yVelocity;
    }

    public Point velocity() {
        return new Point(this.fXVelocity, this.fYVelocity);
    }

    public void animationStep() {
        int xSpeed = this.fXVelocity;
        int ySpeed = this.fYVelocity;
        Rectangle box = this.displayBox();
        if (box.x + box.width > 300 && xSpeed > 0) {
            xSpeed = -xSpeed;
        }
        if (box.y + box.height > 300 && ySpeed > 0) {
            ySpeed = -ySpeed;
        }
        if (box.x < 0 && xSpeed < 0) {
            xSpeed = -xSpeed;
        }
        if (box.y < 0 && ySpeed < 0) {
            ySpeed = -ySpeed;
        }
        this.velocity(xSpeed, ySpeed);
        this.moveBy(xSpeed, ySpeed);
    }

    public synchronized void basicMoveBy(int x, int y) {
        super.basicMoveBy(x, y);
    }

    public synchronized void basicDisplayBox(Point origin, Point corner) {
        super.basicDisplayBox(origin, corner);
    }

    public synchronized Rectangle displayBox() {
        return super.displayBox();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fXVelocity);
        dw.writeInt(this.fYVelocity);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fXVelocity = dr.readInt();
        this.fYVelocity = dr.readInt();
    }
}

