/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.RadiusHandle;
import org.jhotdraw.figures.ShortestDistanceConnector;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class RoundRectangleFigure
extends AttributeFigure {
    private Rectangle fDisplayBox;
    private int fArcWidth;
    private int fArcHeight;
    private static final int DEFAULT_ARC = 8;
    private static final long serialVersionUID = 7907900248924036885L;
    private int roundRectangleSerializedDataVersion = 1;

    public RoundRectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
        this.fArcHeight = 8;
        this.fArcWidth = 8;
    }

    public RoundRectangleFigure(Point origin, Point corner) {
        this.basicDisplayBox(origin, corner);
        this.fArcHeight = 8;
        this.fArcWidth = 8;
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
    }

    public void setArc(int width, int height) {
        this.willChange();
        this.fArcWidth = width;
        this.fArcHeight = height;
        this.changed();
    }

    public Point getArc() {
        return new Point(this.fArcWidth, this.fArcHeight);
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, handles);
        handles.add(new RadiusHandle(this));
        return new HandleEnumerator(handles);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillRoundRect(r.x, r.y, r.width, r.height, this.fArcWidth, this.fArcHeight);
    }

    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, this.fArcWidth, this.fArcHeight);
    }

    public Insets connectionInsets() {
        return new Insets(this.fArcHeight / 2, this.fArcWidth / 2, this.fArcHeight / 2, this.fArcWidth / 2);
    }

    public Connector connectorAt(int x, int y) {
        return new ShortestDistanceConnector(this);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        dw.writeInt(this.fArcWidth);
        dw.writeInt(this.fArcHeight);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.fArcWidth = dr.readInt();
        this.fArcHeight = dr.readInt();
    }
}

