/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Point;
import org.jhotdraw.figures.PolyLineFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.standard.ChopBoxConnector;
import org.jhotdraw.util.Geom;

public class PolyLineConnector
extends ChopBoxConnector {
    private static final long serialVersionUID = 6018435940519102865L;

    public PolyLineConnector() {
    }

    public PolyLineConnector(Figure owner) {
        super(owner);
    }

    protected Point chop(Figure target, Point from) {
        PolyLineFigure p = (PolyLineFigure)this.owner();
        Point ctr = p.center();
        int cx = -1;
        int cy = -1;
        long len = Long.MAX_VALUE;
        int i = 0;
        while (i < p.pointCount() - 1) {
            long cl;
            Point p1 = p.pointAt(i);
            Point p2 = p.pointAt(i + 1);
            Point chop = Geom.intersect(p1.x, p1.y, p2.x, p2.y, from.x, from.y, ctr.x, ctr.y);
            if (chop != null && (cl = Geom.length2(chop.x, chop.y, from.x, from.y)) < len) {
                len = cl;
                cx = chop.x;
                cy = chop.y;
            }
            ++i;
        }
        i = 0;
        while (i < p.pointCount()) {
            Point pp = p.pointAt(i);
            long l = Geom.length2(pp.x, pp.y, from.x, from.y);
            if (l < len) {
                len = l;
                cx = pp.x;
                cy = pp.y;
            }
            ++i;
        }
        return new Point(cx, cy);
    }
}

