/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.BoxHandleKit;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Iconkit;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ImageFigure
extends AttributeFigure
implements ImageObserver {
    private String fFileName;
    private transient Image fImage;
    private Rectangle fDisplayBox;
    private static final long serialVersionUID = 148012030121282439L;
    private int imageFigureSerializedDataVersion = 1;

    public ImageFigure() {
        this.fFileName = null;
        this.fImage = null;
        this.fDisplayBox = null;
    }

    public ImageFigure(Image image, String fileName, Point origin) {
        this.fFileName = fileName;
        this.fImage = image;
        this.basicDisplayBox(origin, new Point(origin.x + this.fImage.getWidth(this), origin.y + this.fImage.getHeight(this)));
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
    }

    public HandleEnumeration handles() {
        List handles = CollectionsFactory.current().createList();
        BoxHandleKit.addHandles(this, handles);
        return new HandleEnumerator(handles);
    }

    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    public void draw(Graphics g) {
        if (this.fImage == null) {
            this.fImage = Iconkit.instance().loadImage(this.fFileName, true);
        }
        if (this.fImage != null) {
            g.drawImage(this.fImage, this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height, this);
        } else {
            this.drawGhost(g);
        }
    }

    private void drawGhost(Graphics g) {
        g.setColor(Color.gray);
        g.fillRect(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.invalidate();
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent(this));
            }
        }
        return (flags & 0xA0) == 0;
    }

    public void release() {
        this.fImage.flush();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        dw.writeString(this.fFileName);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.fFileName = dr.readString();
        Iconkit.instance().registerImage(this.fFileName);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Iconkit.instance().registerImage(this.fFileName);
        this.fImage = null;
    }
}

