/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.util.List;
import org.jhotdraw.figures.GroupFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class GroupCommand
extends AbstractCommand {
    public GroupCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        ((UndoActivity)this.getUndoActivity()).groupFigures();
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 1;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
            List affectedFigures = CollectionsFactory.current().createList();
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                this.getDrawingView().drawing().addAll(currentFigure.figures());
                this.getDrawingView().addToSelectionAll(currentFigure.figures());
                FigureEnumeration groupedFigures = currentFigure.figures();
                while (groupedFigures.hasNextFigure()) {
                    affectedFigures.add(groupedFigures.nextFigure());
                }
            }
            this.setAffectedFigures(new FigureEnumerator(affectedFigures));
            return true;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.groupFigures();
                return true;
            }
            return false;
        }

        public void groupFigures() {
            this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
            this.getDrawingView().clearSelection();
            GroupFigure group = new GroupFigure();
            group.addAll(this.getAffectedFigures());
            Figure figure = this.getDrawingView().drawing().add(group);
            this.getDrawingView().addToSelection(figure);
            List affectedFigures = CollectionsFactory.current().createList();
            affectedFigures.add(figure);
            this.setAffectedFigures(new FigureEnumerator(affectedFigures));
        }
    }
}

