/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JPopupMenu;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class FigureAttributes
implements Cloneable,
Serializable {
    private Map fMap = CollectionsFactory.current().createMap();
    private static final long serialVersionUID = -6886355144423666716L;
    private int figureAttributesSerializedDataVersion = 1;

    public Object get(FigureAttributeConstant attributeConstant) {
        return this.fMap.get(attributeConstant);
    }

    public void set(FigureAttributeConstant attributeConstant, Object value) {
        if (value != null) {
            this.fMap.put(attributeConstant, value);
        } else {
            this.fMap.remove(attributeConstant);
        }
    }

    public boolean hasDefined(FigureAttributeConstant attributeConstant) {
        return this.fMap.containsKey(attributeConstant);
    }

    public Object clone() {
        try {
            FigureAttributes a = (FigureAttributes)super.clone();
            a.fMap = CollectionsFactory.current().createMap(this.fMap);
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void read(StorableInput dr) throws IOException {
        String s = dr.readString();
        if (!s.toLowerCase().equals("attributes")) {
            throw new IOException("Attributes expected");
        }
        this.fMap = CollectionsFactory.current().createMap();
        int size = dr.readInt();
        int i = 0;
        while (i < size) {
            block11: {
                Object val;
                String key;
                block6: {
                    String valtype;
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block5: {
                                        key = dr.readString();
                                        valtype = dr.readString();
                                        val = null;
                                        if (!valtype.equals("Color")) break block5;
                                        val = new Color(dr.readInt(), dr.readInt(), dr.readInt());
                                        break block6;
                                    }
                                    if (!valtype.equals("Boolean")) break block7;
                                    val = new Boolean(dr.readString());
                                    break block6;
                                }
                                if (!valtype.equals("String")) break block8;
                                val = dr.readString();
                                break block6;
                            }
                            if (!valtype.equals("Int")) break block9;
                            val = new Integer(dr.readInt());
                            break block6;
                        }
                        if (!valtype.equals("Storable")) break block10;
                        val = dr.readStorable();
                        break block6;
                    }
                    if (valtype.equals("PopupMenu") || valtype.equals("UNKNOWN")) break block11;
                }
                FigureAttributeConstant attributeConstant = FigureAttributeConstant.getConstant(key);
                this.set(attributeConstant, val);
            }
            ++i;
        }
    }

    public void write(StorableOutput dw) {
        dw.writeString("attributes");
        dw.writeInt(this.fMap.size());
        for (FigureAttributeConstant fac : this.fMap.keySet()) {
            String attributeName = fac.getName();
            Object attributeValue = this.fMap.get(fac);
            dw.writeString(attributeName);
            if (attributeValue instanceof String) {
                dw.writeString("String");
                dw.writeString((String)attributeValue);
                continue;
            }
            if (attributeValue instanceof Color) {
                FigureAttributes.writeColor(dw, "Color", (Color)attributeValue);
                continue;
            }
            if (attributeValue instanceof Boolean) {
                dw.writeString("Boolean");
                if (((Boolean)attributeValue).booleanValue()) {
                    dw.writeString("TRUE");
                    continue;
                }
                dw.writeString("FALSE");
                continue;
            }
            if (attributeValue instanceof Integer) {
                dw.writeString("Int");
                dw.writeInt((Integer)attributeValue);
                continue;
            }
            if (attributeValue instanceof Storable) {
                dw.writeString("Storable");
                dw.writeStorable((Storable)attributeValue);
                continue;
            }
            if (attributeValue instanceof JPopupMenu) {
                dw.writeString("PopupMenu");
                continue;
            }
            System.err.println("Unknown attribute: " + attributeValue);
            dw.writeString("UNKNOWN");
        }
    }

    public static void writeColor(StorableOutput dw, String colorName, Color color) {
        if (color != null) {
            dw.writeString(colorName);
            dw.writeInt(color.getRed());
            dw.writeInt(color.getGreen());
            dw.writeInt(color.getBlue());
        }
    }

    public static Color readColor(StorableInput dr) throws IOException {
        return new Color(dr.readInt(), dr.readInt(), dr.readInt());
    }
}

