/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.event.MouseEvent;
import org.jhotdraw.figures.TextTool;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.DeleteCommand;
import org.jhotdraw.standard.FigureTransferCommand;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.Undoable;

public class ConnectedTextTool
extends TextTool {
    private Figure myConnectedFigure;

    public ConnectedTextTool(DrawingEditor editor, Figure prototype) {
        super(editor, prototype);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        if (this.getTypingTarget() != null) {
            TextHolder textHolder = this.getTypingTarget();
            this.setConnectedFigure(this.drawing().findFigureInsideWithout(x, y, textHolder.getRepresentingFigure()));
            if (this.getConnectedFigure() != null && textHolder != null && this.getConnectedFigure().getTextHolder() != textHolder) {
                textHolder.connect(this.getConnectedFigure().getDecoratedFigure());
                this.getConnectedFigure().addDependendFigure(this.getAddedFigure());
            }
        }
    }

    protected void endEdit() {
        super.endEdit();
        if (this.getUndoActivity() != null && this.getUndoActivity() instanceof UndoActivity) {
            ((UndoActivity)this.getUndoActivity()).setConnectedFigure(this.getConnectedFigure());
        } else if (this.getConnectedFigure() != null && this.isDeleteTextFigure()) {
            this.getConnectedFigure().removeDependendFigure(this.getAddedFigure());
        }
    }

    protected void setConnectedFigure(Figure pressedFigure) {
        this.myConnectedFigure = pressedFigure;
    }

    public Figure getConnectedFigure() {
        return this.myConnectedFigure;
    }

    public void activate() {
        super.activate();
        this.setConnectedFigure(null);
    }

    protected Undoable createDeleteUndoActivity() {
        DeleteCommand cmd = new DeleteCommand("Delete", this.editor());
        return new DeleteUndoActivity(cmd, this.getConnectedFigure());
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getTypingTarget().getText());
    }

    public static class UndoActivity
    extends TextTool.UndoActivity {
        private Figure myConnectedFigure;

        public UndoActivity(DrawingView newDrawingView, String newOriginalText) {
            super(newDrawingView, newOriginalText);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                if (currentFigure.getTextHolder() == null) continue;
                if (!this.isValidText(this.getOriginalText())) {
                    currentFigure.getTextHolder().disconnect(this.getConnectedFigure());
                    continue;
                }
                if (this.isValidText(this.getBackupText())) continue;
                currentFigure.getTextHolder().connect(this.getConnectedFigure());
            }
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                if (currentFigure.getTextHolder() == null) continue;
                if (!this.isValidText(this.getBackupText())) {
                    currentFigure.getTextHolder().disconnect(this.getConnectedFigure());
                    continue;
                }
                if (this.isValidText(this.getOriginalText())) continue;
                currentFigure.getTextHolder().connect(this.getConnectedFigure());
            }
            return true;
        }

        public void setConnectedFigure(Figure newConnectedFigure) {
            this.myConnectedFigure = newConnectedFigure;
        }

        public Figure getConnectedFigure() {
            return this.myConnectedFigure;
        }
    }

    public static class DeleteUndoActivity
    extends DeleteCommand.UndoActivity {
        private Figure myConnectedFigure;

        public DeleteUndoActivity(FigureTransferCommand cmd, Figure newConnectedFigure) {
            super(cmd);
            this.setConnectedFigure(newConnectedFigure);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                if (currentFigure.getTextHolder() == null) continue;
                currentFigure.getTextHolder().connect(this.getConnectedFigure().getDecoratedFigure());
            }
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasNextFigure()) {
                Figure currentFigure = fe.nextFigure();
                if (currentFigure.getTextHolder() == null) continue;
                currentFigure.getTextHolder().disconnect(this.getConnectedFigure().getDecoratedFigure());
            }
            return true;
        }

        public void setConnectedFigure(Figure newConnectedFigure) {
            this.myConnectedFigure = newConnectedFigure;
        }

        public Figure getConnectedFigure() {
            return this.myConnectedFigure;
        }
    }
}

