/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.event.MouseEvent;
import java.util.List;
import org.jhotdraw.figures.BorderDecorator;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.ActionTool;
import org.jhotdraw.standard.DecoratorFigure;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class BorderTool
extends ActionTool {
    public BorderTool(DrawingEditor editor) {
        super(editor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.setView((DrawingView)e.getSource());
        if ((e.getModifiers() & 2) == 0) {
            super.mouseDown(e, x, y);
        } else {
            Figure target = this.drawing().findFigure(x, y);
            if (target != null && target != target.getDecoratedFigure()) {
                this.view().addToSelection(target);
                this.reverseAction(target);
            }
        }
    }

    public void action(Figure figure) {
        this.setUndoActivity(this.createUndoActivity());
        List l = CollectionsFactory.current().createList();
        l.add(figure);
        l.add(new BorderDecorator(figure));
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(l));
        ((UndoActivity)this.getUndoActivity()).replaceAffectedFigures();
    }

    public void reverseAction(Figure figure) {
        this.setUndoActivity(this.createUndoActivity());
        List l = CollectionsFactory.current().createList();
        l.add(figure);
        l.add(((DecoratorFigure)figure).peelDecoration());
        this.getUndoActivity().setAffectedFigures(new FigureEnumerator(l));
        ((UndoActivity)this.getUndoActivity()).replaceAffectedFigures();
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            return this.replaceAffectedFigures();
        }

        public boolean replaceAffectedFigures() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            Figure oldFigure = fe.nextFigure();
            if (!fe.hasNextFigure()) {
                return false;
            }
            Figure replaceFigure = fe.nextFigure();
            replaceFigure = this.getDrawingView().drawing().replace(oldFigure, replaceFigure);
            List l = CollectionsFactory.current().createList();
            l.add(replaceFigure);
            l.add(oldFigure);
            this.setAffectedFigures(new FigureEnumerator(l));
            return true;
        }
    }
}

