/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import org.jhotdraw.figures.FigureAttributes;
import org.jhotdraw.figures.LineDecoration;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class AbstractLineDecoration
implements LineDecoration {
    static final long serialVersionUID = 1577970039258356627L;
    private Color fFillColor;
    private Color fBorderColor;
    private transient Rectangle myBounds;

    public void draw(Graphics g, int x1, int y1, int x2, int y2) {
        Color drawColor;
        Polygon p = this.outline(x1, y1, x2, y2);
        this.myBounds = p.getBounds();
        if (this.getFillColor() == null) {
            g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
        } else {
            drawColor = g.getColor();
            g.setColor(this.getFillColor());
            g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
            g.setColor(drawColor);
        }
        if (this.getBorderColor() != this.getFillColor()) {
            drawColor = g.getColor();
            g.setColor(this.getBorderColor());
            g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
            g.setColor(drawColor);
        }
    }

    public Rectangle displayBox() {
        if (this.myBounds != null) {
            return this.myBounds;
        }
        return new Rectangle(0, 0);
    }

    public abstract Polygon outline(int var1, int var2, int var3, int var4);

    public void write(StorableOutput dw) {
        if (this.getFillColor() != null) {
            FigureAttributes.writeColor(dw, FigureAttributeConstant.FILL_COLOR.getName(), this.getFillColor());
        } else {
            dw.writeString("no" + FigureAttributeConstant.FILL_COLOR.getName());
        }
        if (this.getBorderColor() != null) {
            FigureAttributes.writeColor(dw, FigureAttributeConstant.FRAME_COLOR.getName(), this.getBorderColor());
        } else {
            dw.writeString("no" + FigureAttributeConstant.FRAME_COLOR.getName());
        }
    }

    public void read(StorableInput dr) throws IOException {
        String borderColorId;
        String fillColorId = dr.readString();
        if (fillColorId.equals(FigureAttributeConstant.FILL_COLOR.getName())) {
            this.setFillColor(FigureAttributes.readColor(dr));
        }
        if ((borderColorId = dr.readString()).equals("BorderColor") || borderColorId.equals(FigureAttributeConstant.FRAME_COLOR.getName())) {
            this.setBorderColor(FigureAttributes.readColor(dr));
        }
    }

    public void setFillColor(Color fillColor) {
        this.fFillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fFillColor;
    }

    public void setBorderColor(Color borderColor) {
        this.fBorderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.fBorderColor;
    }
}

