/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import org.jhotdraw.contrib.zoom.ScalingGraphics;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Painter;

public class ZoomUpdateStrategy
implements Painter {
    private transient Image fOffscreen;
    private int fImagewidth = -1;
    private int fImageheight = -1;

    public void draw(Graphics g, DrawingView view) {
        Dimension d = view.getSize();
        if (this.fOffscreen == null || d.width != this.fImagewidth || d.height != this.fImageheight) {
            this.fOffscreen = view.createImage(d.width, d.height);
            this.fImagewidth = d.width;
            this.fImageheight = d.height;
        }
        Graphics g2 = this.fOffscreen.getGraphics();
        Rectangle r = g.getClipBounds();
        if (g2 instanceof ScalingGraphics) {
            ScalingGraphics s2 = (ScalingGraphics)g2;
            if (r != null) {
                r = new Rectangle((int)((double)(r.x - 2) / s2.getScale()), (int)((double)(r.y - 2) / s2.getScale()), (int)((double)(r.width + 4) / s2.getScale()), (int)((double)(r.height + 4) / s2.getScale()));
                g.setClip(r);
            }
        }
        g2.setClip(r);
        view.drawAll(g2);
        g.drawImage(this.fOffscreen, 0, 0, view);
    }
}

