/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.event.MouseEvent;
import org.jhotdraw.contrib.zoom.ZoomAreaTracker;
import org.jhotdraw.contrib.zoom.ZoomDrawingView;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AbstractTool;

public class ZoomTool
extends AbstractTool {
    private Tool child;

    public ZoomTool(DrawingEditor editor) {
        super(editor);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        if ((e.getModifiers() & 0x10) != 0) {
            if (this.child != null) {
                return;
            }
            this.view().freezeView();
            this.child = new ZoomAreaTracker(this.editor());
            this.child.mouseDown(e, x, y);
        } else if ((e.getModifiers() & 8) != 0) {
            ((ZoomDrawingView)this.view()).deZoom(x, y);
        } else if ((e.getModifiers() & 4) != 0) {
            if ((e.getModifiers() & 1) != 0) {
                ((ZoomDrawingView)this.view()).zoomIn(x, y);
            } else if ((e.getModifiers() & 2) != 0) {
                ((ZoomDrawingView)this.view()).deZoom(x, y);
            } else {
                ((ZoomDrawingView)this.view()).zoomOut(x, y);
            }
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.child != null) {
            this.child.mouseDrag(e, x, y);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        if (this.child != null) {
            this.view().unfreezeView();
            this.child.mouseUp(e, x, y);
        }
        this.child = null;
    }
}

