/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JViewport;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingChangeEvent;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.standard.StandardDrawing;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.util.Geom;

public class ZoomDrawingView
extends StandardDrawingView {
    private double scale = 1.0;
    private double zoomSpeed = 2.0;

    public ZoomDrawingView(DrawingEditor editor) {
        this(editor, 400, 300);
    }

    public ZoomDrawingView(DrawingEditor editor, int width, int height) {
        super(editor, width, height);
    }

    public final double getScale() {
        return this.scale;
    }

    private void setScale(double newScale) {
        Dimension oldSize = this.getUserSize();
        this.scale = newScale;
        this.setUserSize(oldSize.width, oldSize.height);
        this.centralize(this.drawing());
        this.forceRedraw();
    }

    private void forceRedraw() {
        this.drawingInvalidated(new DrawingChangeEvent(this.drawing(), new Rectangle(this.getSize())));
        this.repairDamage();
    }

    public void setUserSize(int width, int height) {
        this.setSize((int)((double)width * this.getScale()), (int)((double)height * this.getScale()));
    }

    public void setUserSize(Dimension d) {
        this.setUserSize(d.width, d.height);
    }

    public Dimension getSize() {
        return super.getSize();
    }

    public Dimension getViewportSize() {
        return this.getParent().getSize();
    }

    protected boolean hasZoomSupport() {
        return this.getParent() instanceof JViewport;
    }

    public void setOriginPosition(Point newOrigin) {
        this.setViewPosition(newOrigin);
        this.forceRedraw();
    }

    protected void setViewPosition(Point newPosition) {
        ((JViewport)this.getParent()).setViewPosition(newPosition);
    }

    public Dimension getUserSize() {
        Dimension screenSize = this.getSize();
        return new Dimension((int)((double)screenSize.width / this.getScale()), (int)((double)screenSize.height / this.getScale()));
    }

    public void zoom(int x, int y, int width, int height) {
        if (!this.hasZoomSupport()) {
            throw new JHotDrawRuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        Dimension viewportSize = this.getViewportSize();
        double xScale = (double)viewportSize.width / (double)width;
        double yScale = (double)viewportSize.height / (double)height;
        double newScale = Math.min(xScale, yScale);
        Dimension userSize = this.getUserSize();
        this.scale = newScale;
        this.setUserSize(userSize);
        this.revalidate();
        this.setViewPosition(new Point((int)((double)x * this.getScale()), (int)((double)y * this.getScale())));
        this.forceRedraw();
    }

    public void zoom(float newScale) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        JViewport viewport;
        if (this.hasZoomSupport()) {
            viewport = (JViewport)this.getParent();
            Dimension viewportSize = viewport.getSize();
            userSize = this.getUserSize();
            this.scale = newScale;
            Point viewOrg = viewport.getViewPosition();
            viewOrg.x += viewportSize.width / 2;
            viewOrg.y += viewportSize.height / 2;
            int xScreen = (int)((double)viewOrg.x * this.scale);
            int yScreen = (int)((double)viewOrg.y * this.scale);
            xOrigin = xScreen - viewportSize.width / 2;
            yOrigin = yScreen - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
        } else {
            throw new JHotDrawRuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(userSize);
        this.revalidate();
        viewport.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }

    public void zoomOut(int x, int y) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        if (this.hasZoomSupport()) {
            Dimension viewportSize = this.getViewportSize();
            userSize = this.getUserSize();
            this.scale = this.getScale() / this.getZoomSpeed();
            int xScreen = (int)((double)x * this.getScale());
            int yScreen = (int)((double)y * this.getScale());
            xOrigin = xScreen - viewportSize.width / 2;
            yOrigin = yScreen - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
        } else {
            throw new JHotDrawRuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(userSize);
        this.revalidate();
        this.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }

    public void zoomIn(int x, int y) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        JViewport viewport;
        if (this.hasZoomSupport()) {
            viewport = (JViewport)this.getParent();
            Dimension viewportSize = viewport.getSize();
            userSize = this.getUserSize();
            this.scale = this.getScale() * this.getZoomSpeed();
            int xScreen = (int)((double)x * this.getScale());
            int yScreen = (int)((double)y * this.getScale());
            xOrigin = xScreen - viewportSize.width / 2;
            yOrigin = yScreen - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
        } else {
            throw new JHotDrawRuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.setUserSize(userSize);
        this.revalidate();
        viewport.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }

    public void deZoom(int x, int y) {
        int yOrigin;
        int xOrigin;
        Dimension userSize;
        if (this.hasZoomSupport()) {
            Dimension viewportSize = this.getViewportSize();
            userSize = this.getUserSize();
            xOrigin = x - viewportSize.width / 2;
            yOrigin = y - viewportSize.height / 2;
            if (xOrigin < 0) {
                xOrigin = 0;
            }
            if (yOrigin < 0) {
                yOrigin = 0;
            }
        } else {
            throw new JHotDrawRuntimeException("zooming only works if this view is contained in a ScrollPane");
        }
        this.scale = 1.0;
        this.setUserSize(userSize);
        this.revalidate();
        this.setViewPosition(new Point(xOrigin, yOrigin));
        this.forceRedraw();
    }

    public void paint(Graphics g) {
        super.paint(this.transformGraphics(g, this.getScale()));
    }

    public Graphics getGraphics() {
        return this.transformGraphics(super.getGraphics(), this.getScale());
    }

    private final Graphics transformGraphics(Graphics g, double currentScale) {
        if (currentScale != 1.0) {
            Graphics2D g2 = (Graphics2D)g;
            g2.transform(AffineTransform.getScaleInstance(currentScale, currentScale));
        }
        return g;
    }

    protected Point constrainPoint(Point p) {
        Dimension size = this.getSize();
        p.x = Geom.range(1, (int)((double)size.width / this.getScale()), p.x);
        p.y = Geom.range(1, (int)((double)size.height / this.getScale()), p.y);
        if (this.getConstrainer() != null) {
            return this.getConstrainer().constrainPoint(p);
        }
        return p;
    }

    public void drawBackground(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, (int)((double)this.getBounds().width / this.getScale()), (int)((double)this.getBounds().height / this.getScale()));
    }

    private void centralize(Drawing d, Dimension bounds) {
        Point boundsCenter = new Point(bounds.width / 2, bounds.height / 2);
        Rectangle r = ((StandardDrawing)d).displayBox();
        Point drawingCenter = new Point(r.x + r.width / 2, r.y + r.height / 2);
        int diffX = boundsCenter.x - drawingCenter.x;
        int diffY = boundsCenter.y - drawingCenter.y;
        if (diffX != 0 || diffY != 0) {
            FigureEnumeration fe = d.figures();
            while (fe.hasNextFigure()) {
                fe.nextFigure().moveBy(diffX, diffY);
            }
        }
    }

    private void centralize(Drawing d) {
        this.centralize(d, this.getUserSize());
    }

    public void setDrawing(Drawing d) {
        super.setDrawing(d);
        Rectangle r = ((StandardDrawing)d).displayBox();
        Dimension viewportSize = new Dimension(r.width, r.height);
        if (this.getParent() != null) {
            viewportSize = this.getViewportSize();
        }
        super.setPreferredSize(viewportSize);
        super.setSize(viewportSize);
        this.revalidate();
    }

    public Dimension getMinimumSize() {
        return super.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void repairDamage() {
        Rectangle damagedArea = this.getDamage();
        if (damagedArea != null) {
            this.repaint((int)((double)damagedArea.x * this.getScale()), (int)((double)damagedArea.y * this.getScale()), (int)((double)damagedArea.width * this.getScale()), (int)((double)damagedArea.height * this.getScale()));
            this.setDamage(null);
        }
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        Rectangle r = e.getInvalidatedRectangle();
        if (this.getDamage() == null) {
            this.setDamage(r);
        } else {
            Rectangle damagedArea = this.getDamage();
            damagedArea.add(r);
            this.setDamage(damagedArea);
        }
    }

    private MouseEvent createScaledEvent(MouseEvent e) {
        return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), (int)((double)e.getX() / this.getScale()), (int)((double)e.getY() / this.getScale()), e.getClickCount(), e.isPopupTrigger());
    }

    protected MouseListener createMouseListener() {
        return new StandardDrawingView.DrawingViewMouseListener(this){

            public void mousePressed(MouseEvent e) {
                super.mousePressed(ZoomDrawingView.this.createScaledEvent(e));
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(ZoomDrawingView.this.createScaledEvent(e));
            }
        };
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new StandardDrawingView.DrawingViewMouseMotionListener(this){

            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(ZoomDrawingView.this.createScaledEvent(e));
            }

            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(ZoomDrawingView.this.createScaledEvent(e));
            }
        };
    }

    protected KeyListener createKeyListener() {
        return new StandardDrawingView.DrawingViewKeyListener(this){

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyChar() == ' ') {
                    ZoomDrawingView.this.forceRedraw();
                } else if (e.getKeyChar() == 'o') {
                    ZoomDrawingView.this.setScale(ZoomDrawingView.this.getScale() / ZoomDrawingView.this.getZoomSpeed());
                } else if (e.getKeyChar() == 'i') {
                    ZoomDrawingView.this.setScale(ZoomDrawingView.this.getScale() * ZoomDrawingView.this.getZoomSpeed());
                } else if (e.getKeyChar() == 'c') {
                    ZoomDrawingView.this.centralize(ZoomDrawingView.this.drawing());
                } else {
                    super.keyPressed(e);
                }
            }
        };
    }

    public double getZoomSpeed() {
        return this.zoomSpeed;
    }

    public void setZoomSpeed(double newZoomSpeed) {
        this.zoomSpeed = Math.max(1.1, newZoomSpeed);
    }
}

