/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.zoom;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import org.jhotdraw.contrib.zoom.DoubleBufferImage;

public class ScalingGraphics
extends Graphics {
    private double scale = 1.0;
    private Graphics real;
    private Font userFont;
    private Rectangle userClip;

    public ScalingGraphics(Graphics realGraphics) {
        this.real = realGraphics;
    }

    public void setScale(double newScale) {
        this.scale = newScale;
    }

    public double getScale() {
        return this.scale;
    }

    private static Font scaledFont(Font f, double scale) {
        int size = f.getSize();
        int scaledSize = (int)((double)size * scale);
        return new Font(f.getFamily(), f.getStyle(), scaledSize);
    }

    private static Shape scaledShape(Shape s, double scale) {
        if (s instanceof Rectangle) {
            Rectangle r = (Rectangle)s;
            return new Rectangle((int)((double)r.x * scale), (int)((double)r.y * scale), (int)((double)r.width * scale), (int)((double)r.height * scale));
        }
        throw new RuntimeException("Cannot scale shape: " + s.getClass().getName());
    }

    public Graphics create() {
        Graphics realCopy = this.real.create();
        ScalingGraphics result = new ScalingGraphics(realCopy);
        result.setScale(this.getScale());
        return result;
    }

    public void translate(int x, int y) {
        this.real.translate((int)((double)x * this.scale), (int)((double)y * this.scale));
    }

    public Color getColor() {
        return this.real.getColor();
    }

    public void setColor(Color c) {
        this.real.setColor(c);
    }

    public void setPaintMode() {
        this.real.setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.real.setXORMode(c1);
    }

    public Font getFont() {
        if (this.userFont == null) {
            this.userFont = this.real.getFont();
        }
        return this.userFont;
    }

    public void setFont(Font font) {
        this.userFont = font;
        this.real.setFont(ScalingGraphics.scaledFont(font, this.scale));
    }

    public FontMetrics getFontMetrics() {
        return new ScalingFontMetrics(this.userFont, this.real.getFontMetrics());
    }

    public FontMetrics getFontMetrics(Font f) {
        return new ScalingFontMetrics(f, this.real.getFontMetrics(ScalingGraphics.scaledFont(f, this.scale)));
    }

    public Rectangle getClipBounds() {
        return this.userClip;
    }

    public void clipRect(int x, int y, int width, int height) {
        this.userClip = this.userClip == null ? new Rectangle(x, y, width, height) : this.userClip.intersection(new Rectangle(x, y, width, height));
        this.real.clipRect((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale));
    }

    public void setClip(int x, int y, int width, int height) {
        this.userClip = new Rectangle(x, y, width, height);
        this.real.setClip((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale));
    }

    public Shape getClip() {
        return this.userClip;
    }

    public void setClip(Shape clip) {
        this.userClip = (Rectangle)clip;
        if (clip != null) {
            this.real.setClip(ScalingGraphics.scaledShape(clip, this.scale));
        } else {
            this.real.setClip(null);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.real.copyArea((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale), (int)((double)dx * this.scale), (int)((double)dy * this.scale));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.real.drawLine((int)((double)x1 * this.scale), (int)((double)y1 * this.scale), (int)((double)x2 * this.scale), (int)((double)y2 * this.scale));
    }

    public void fillRect(int x, int y, int width, int height) {
        this.real.fillRect((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale));
    }

    public void clearRect(int x, int y, int width, int height) {
        this.real.clearRect((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale));
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.real.drawRoundRect((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale), (int)((double)arcWidth * this.scale), (int)((double)arcHeight * this.scale));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.real.fillRoundRect((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale), (int)((double)arcWidth * this.scale), (int)((double)arcHeight * this.scale));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.real.drawOval((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.real.fillOval((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale));
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.real.drawArc((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale), startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.real.fillArc((int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale), startAngle, arcAngle);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        int[] realXPoints = new int[nPoints];
        int[] realYPoints = new int[nPoints];
        int i = 0;
        while (i < nPoints) {
            realXPoints[i] = (int)((double)xPoints[i] * this.scale);
            realYPoints[i] = (int)((double)yPoints[i] * this.scale);
            ++i;
        }
        this.real.drawPolyline(realXPoints, realYPoints, nPoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] realXPoints = new int[nPoints];
        int[] realYPoints = new int[nPoints];
        int i = 0;
        while (i < nPoints) {
            realXPoints[i] = (int)((double)xPoints[i] * this.scale);
            realYPoints[i] = (int)((double)yPoints[i] * this.scale);
            ++i;
        }
        this.real.drawPolygon(realXPoints, realYPoints, nPoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] realXPoints = new int[nPoints];
        int[] realYPoints = new int[nPoints];
        int i = 0;
        while (i < nPoints) {
            realXPoints[i] = (int)((double)xPoints[i] * this.scale);
            realYPoints[i] = (int)((double)yPoints[i] * this.scale);
            ++i;
        }
        this.real.fillPolygon(realXPoints, realYPoints, nPoints);
    }

    public void drawString(String str, int x, int y) {
        this.real.drawString(str, (int)((double)x * this.scale), (int)((double)y * this.scale));
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.real.drawString(iterator, (int)((double)x * this.scale), (int)((double)y * this.scale));
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)img).getRealImage(), x, y, observer);
        }
        return this.real.drawImage(img, (int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)img.getWidth(observer) * this.scale), (int)((double)img.getHeight(observer) * this.scale), observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (img instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)img).getRealImage(), x, y, width, height, observer);
        }
        return this.real.drawImage(img, (int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale), observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)img).getRealImage(), x, y, bgcolor, observer);
        }
        return this.real.drawImage(img, (int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)img.getWidth(observer) * this.scale), (int)((double)img.getHeight(observer) * this.scale), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (img instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)img).getRealImage(), x, y, width, height, bgcolor, observer);
        }
        return this.real.drawImage(img, (int)((double)x * this.scale), (int)((double)y * this.scale), (int)((double)width * this.scale), (int)((double)height * this.scale), bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (img instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)img).getRealImage(), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
        return this.real.drawImage(img, (int)((double)dx1 * this.scale), (int)((double)dy1 * this.scale), (int)((double)dx2 * this.scale), (int)((double)dy2 * this.scale), (int)((double)sx1 * this.scale), (int)((double)sy1 * this.scale), (int)((double)sx2 * this.scale), (int)((double)sy2 * this.scale), observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img instanceof DoubleBufferImage) {
            return this.real.drawImage(((DoubleBufferImage)img).getRealImage(), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        }
        return this.real.drawImage(img, (int)((double)dx1 * this.scale), (int)((double)dy1 * this.scale), (int)((double)dx2 * this.scale), (int)((double)dy2 * this.scale), (int)((double)sx1 * this.scale), (int)((double)sy1 * this.scale), (int)((double)sx2 * this.scale), (int)((double)sy2 * this.scale), bgcolor, observer);
    }

    public void dispose() {
        this.real.dispose();
    }

    private class ScalingFontMetrics
    extends FontMetrics {
        private FontMetrics real;
        private Font userFont;

        public ScalingFontMetrics(Font newUserFont, FontMetrics newReal) {
            super(null);
            this.userFont = newUserFont;
            this.real = newReal;
        }

        public Font getFont() {
            return this.userFont;
        }

        public int getAscent() {
            return (int)((double)this.real.getAscent() / ScalingGraphics.this.getScale());
        }

        public int getLeading() {
            return (int)((double)this.real.getLeading() / ScalingGraphics.this.getScale());
        }

        public int getMaxAdvance() {
            return (int)((double)this.real.getMaxAdvance() / ScalingGraphics.this.getScale());
        }

        public int charWidth(char ch) {
            return (int)((double)this.real.charWidth(ch) / ScalingGraphics.this.getScale());
        }

        public int charsWidth(char[] data, int off, int len) {
            return (int)((double)this.real.charsWidth(data, off, len) / ScalingGraphics.this.getScale());
        }
    }
}

