/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.util.Iterator;
import java.util.WeakHashMap;
import org.jhotdraw.contrib.html.DisposableResourceHolder;
import org.jhotdraw.contrib.html.DisposableResourceManager;
import org.jhotdraw.contrib.html.ResourceDisposabilityStrategy;
import org.jhotdraw.contrib.html.ResourceManagerNotSetException;

public class StandardDisposableResourceManager
implements DisposableResourceManager {
    private WeakHashMap resources = new WeakHashMap();
    private ResourceDisposabilityStrategy strategy;

    public StandardDisposableResourceManager(ResourceDisposabilityStrategy newStrategy) {
        this.setStrategy(newStrategy);
        this.getStrategy().setManager(this);
    }

    public synchronized void registerResource(DisposableResourceHolder resource) {
        this.resources.put(resource, resource);
    }

    public synchronized void unregisterResource(DisposableResourceHolder resource) {
        this.resources.remove(resource);
    }

    public Iterator getResources() {
        return this.resources.values().iterator();
    }

    public synchronized boolean managesResource(DisposableResourceHolder resource) {
        return this.resources.containsValue(resource);
    }

    public ResourceDisposabilityStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ResourceDisposabilityStrategy newStrategy) {
        this.strategy = newStrategy;
    }

    public void startDisposing() throws ResourceManagerNotSetException {
        this.getStrategy().startDisposing();
    }

    public void stopDisposing(long millis) {
        this.getStrategy().stopDisposing(millis);
    }
}

