/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.jhotdraw.contrib.TextAreaFigure;
import org.jhotdraw.contrib.html.ContentProducer;
import org.jhotdraw.contrib.html.ContentProducerRegistry;
import org.jhotdraw.contrib.html.DisposableResourceHolder;
import org.jhotdraw.contrib.html.DisposableResourceManagerFactory;
import org.jhotdraw.contrib.html.GeometricFigure;
import org.jhotdraw.contrib.html.HTMLColorContentProducer;
import org.jhotdraw.contrib.html.HTMLContentProducer;
import org.jhotdraw.contrib.html.HTMLContentProducerContext;
import org.jhotdraw.contrib.html.TextHolderContentProducer;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class HTMLTextAreaFigure
extends TextAreaFigure
implements HTMLContentProducerContext,
FigureChangeListener {
    public static final char START_ENTITY_CHAR = '&';
    public static final char END_ENTITY_CHAR = ';';
    public static final char ESCAPE_CHAR = '\\';
    private transient DisposableResourceHolder fImageHolder;
    private transient JLabel fDisplayDelegate;
    private boolean fUseDirectDraw = false;
    private boolean fIsImageDirty = true;
    private boolean fRawHTML = false;
    private transient ContentProducer fIntrinsicContentProducer;
    private static ContentProducerRegistry fDefaultContentProducers = new ContentProducerRegistry();
    private transient ContentProducerRegistry fContentProducers = null;
    private Figure fFrameFigure = null;

    static {
        fDefaultContentProducers.registerContentProducer(TextAreaFigure.class, new TextHolderContentProducer());
        fDefaultContentProducers.registerContentProducer(Color.class, new HTMLColorContentProducer());
        HTMLTextAreaFigure.initDefaultAttribute("XAlignment", new Integer(2));
        HTMLTextAreaFigure.initDefaultAttribute("YAlignment", new Integer(1));
        HTMLTextAreaFigure.initDefaultAttribute("LeftMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("RightMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("TopMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("BottomMargin", new Float(5.0f));
        HTMLTextAreaFigure.initDefaultAttribute("TabSize", new Float(8.0f));
    }

    public HTMLTextAreaFigure() {
        this.initialize();
    }

    public Object clone() {
        Object cloneObject = super.clone();
        ((HTMLTextAreaFigure)cloneObject).initialize();
        return cloneObject;
    }

    public void basicDisplayBox(Point origin, Point corner) {
        super.basicDisplayBox(origin, corner);
        this.getFrameFigure().displayBox(this.displayBox());
    }

    public HandleEnumeration handles() {
        return this.getFrameFigure().handles();
    }

    public boolean containsPoint(int x, int y) {
        return this.getFrameFigure().containsPoint(x, y);
    }

    public void moveBy(int dx, int dy) {
        super.moveBy(dx, dy);
        this.getFrameFigure().moveBy(dx, dy);
    }

    protected void initialize() {
        this.fImageHolder = DisposableResourceManagerFactory.createStandardHolder(null);
        this.setFrameFigure(new RectangleFigure());
        this.setIntrinsicContentProducer(new HTMLContentProducer());
        this.fContentProducers = new ContentProducerRegistry(fDefaultContentProducers);
        this.markSizeDirty();
        this.markImageDirty();
        this.markTextDirty();
        this.markFontDirty();
        this.setAttribute(FigureAttributeConstant.POPUP_MENU, (Object)this.createPopupMenu());
    }

    protected void markSizeDirty() {
        this.markImageDirty();
        super.markSizeDirty();
    }

    protected void markTextDirty() {
        this.markImageDirty();
        super.markTextDirty();
    }

    protected void markFontDirty() {
        this.markImageDirty();
        super.markFontDirty();
    }

    public void draw(Graphics g) {
        Color fill = this.getFillColor();
        g.setColor(fill);
        this.drawBackground(g);
        this.drawText(g, this.displayBox());
        Color frame = this.getFrameColor();
        g.setColor(frame);
        this.drawFrame(g);
    }

    public void drawFrame(Graphics g) {
        ((Graphics2D)g).draw(this.getClippingShape());
    }

    public void drawBackground(Graphics g) {
        ((Graphics2D)g).fill(this.getClippingShape());
    }

    protected float drawText(Graphics g, Rectangle displayBox) {
        Rectangle drawingBox;
        Graphics2D g2 = null;
        Shape savedClip = null;
        if (g != null) {
            g2 = (Graphics2D)g;
            savedClip = g2.getClip();
        }
        if ((drawingBox = this.makeDrawingBox(displayBox)).isEmpty()) {
            return drawingBox.height;
        }
        if (g != null) {
            g2.clip(this.getClippingShape());
        }
        if (this.usesDirectDraw()) {
            this.drawTextDirect(g2, drawingBox);
        } else {
            this.fImageHolder.lock();
            if (this.isImageDirty()) {
                this.generateImage(drawingBox);
                this.setSizeDirty(false);
            }
            if (g2 != null) {
                g2.drawImage((Image)this.getImage(), drawingBox.x, drawingBox.y, null);
            }
            this.fImageHolder.unlock();
        }
        if (g != null) {
            g2.setClip(savedClip);
        }
        this.drawFrame(g);
        return displayBox.height;
    }

    protected void generateImage(Rectangle drawingBox) {
        this.createImage(drawingBox.width, drawingBox.height);
        Graphics2D g2 = (Graphics2D)this.getImage().getGraphics();
        Rectangle finalBox = new Rectangle(drawingBox);
        finalBox.setLocation(0, 0);
        this.renderText(g2, finalBox);
        g2.dispose();
    }

    protected void drawTextDirect(Graphics2D g2, Rectangle drawingBox) {
        Shape savedClipArea = null;
        Color savedFontColor = null;
        RenderingHints savedRenderingHints = null;
        if (g2 != null) {
            savedRenderingHints = g2.getRenderingHints();
            savedClipArea = g2.getClip();
            savedFontColor = g2.getColor();
            g2.clip(drawingBox);
        }
        if (g2 != null) {
            g2.setClip(savedClipArea);
            g2.setColor(savedFontColor);
            g2.setRenderingHints(savedRenderingHints);
        }
    }

    protected float renderText(Graphics2D g2, Rectangle drawingBox) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setBackground(this.getFillColor());
        g2.setColor(this.getFillColor());
        g2.clearRect(drawingBox.x, drawingBox.y, drawingBox.width, drawingBox.height);
        g2.fillRect(drawingBox.x, drawingBox.y, drawingBox.width, drawingBox.height);
        String text = this.isRawHTML() ? this.getText() : this.getHTMLText(this.getText(), this.getFont(), (String)this.getContentProducer(Color.class).getContent(this, "TextColor", this.getTextColor()), (String)this.getContentProducer(Color.class).getContent(this, "FillColor", this.getFillColor()), drawingBox);
        text = this.substituteEntityKeywords(text);
        JLabel displayDelegate = this.getDisplayDelegate();
        displayDelegate.setText(text);
        displayDelegate.setBackground(this.getFillColor());
        displayDelegate.setLocation(0, 0);
        displayDelegate.setSize(drawingBox.width, drawingBox.height);
        displayDelegate.setHorizontalAlignment((Integer)this.getAttribute(FigureAttributeConstant.XALIGNMENT));
        displayDelegate.setVerticalAlignment((Integer)this.getAttribute(FigureAttributeConstant.YALIGNMENT));
        SwingUtilities.paintComponent(g2, displayDelegate, this.getContainerPanel(displayDelegate, drawingBox), drawingBox.x, drawingBox.y, drawingBox.width, drawingBox.height);
        return drawingBox.height;
    }

    protected Rectangle makeDrawingBox(Rectangle displayBox) {
        float leftMargin = ((Float)this.getAttribute(FigureAttributeConstant.LEFT_MARGIN)).floatValue();
        float rightMargin = ((Float)this.getAttribute(FigureAttributeConstant.RIGHT_MARGIN)).floatValue();
        float topMargin = ((Float)this.getAttribute(FigureAttributeConstant.TOP_MARGIN)).floatValue();
        float bottomMargin = ((Float)this.getAttribute(FigureAttributeConstant.BOTTOM_MARGIN)).floatValue();
        Rectangle drawingBox = new Rectangle(displayBox);
        drawingBox.grow(-1, -1);
        drawingBox.x = (int)((float)drawingBox.x + leftMargin);
        drawingBox.width = (int)((float)drawingBox.width - (leftMargin + rightMargin));
        drawingBox.y = (int)((float)drawingBox.y + topMargin);
        drawingBox.height = (int)((float)drawingBox.height - (topMargin + bottomMargin));
        return drawingBox;
    }

    protected JLabel getDisplayDelegate() {
        if (this.fDisplayDelegate == null) {
            this.fDisplayDelegate = new JLabel();
            this.fDisplayDelegate.setBorder(null);
        }
        return this.fDisplayDelegate;
    }

    protected void createImage(int width, int height) {
        this.fImageHolder.lock();
        if (!this.fImageHolder.isAvailable() || ((BufferedImage)this.fImageHolder.getResource()).getWidth() != width || ((BufferedImage)this.fImageHolder.getResource()).getHeight() != height) {
            this.fImageHolder.setResource(new BufferedImage(width, height, 1));
        }
    }

    protected JPanel getContainerPanel(Component drawingDelegate, Rectangle displayBox) {
        JPanel panel = new JPanel();
        return panel;
    }

    protected String getHTMLText(String text, Font font, String textColor, String backColor, Rectangle displayBox) {
        StringBuffer htmlText = new StringBuffer();
        htmlText.append("<html>");
        htmlText.append("<table border='0' width='" + displayBox.width + "' height='" + displayBox.height + "' cellpadding='0' cellspacing='0'" + "bgcolor='&FillColor;'>");
        htmlText.append("<tr><td width='100%'>");
        htmlText.append("<font face='&FontName;' color='&TextColor;' size='&FontSize;'>");
        if ((Integer)this.getAttribute(FigureAttributeConstant.XALIGNMENT) == 0) {
            htmlText.append("<center>");
        }
        if (font.isItalic()) {
            htmlText.append("<i>");
        }
        if (font.isBold()) {
            htmlText.append("<b>");
        }
        htmlText.append(text);
        if (font.isBold()) {
            htmlText.append("</b>");
        }
        if (font.isItalic()) {
            htmlText.append("</i>");
        }
        if ((Integer)this.getAttribute(FigureAttributeConstant.XALIGNMENT) == 0) {
            htmlText.append("</center>");
        }
        htmlText.append("</font>");
        htmlText.append("</td></tr></table>");
        htmlText.append("</html>");
        return htmlText.toString();
    }

    protected String substituteEntityKeywords(String template) {
        int startPos;
        StringBuffer finalText = new StringBuffer();
        int chunkEnd = startPos = 0;
        try {
            while ((startPos = template.indexOf(38, startPos)) != -1) {
                if (startPos != 0 && template.charAt(startPos - 1) == '\\') {
                    ++startPos;
                    continue;
                }
                int endPos = startPos + 1;
                if ((endPos = template.indexOf(59, endPos)) != -1 && endPos != 0 && template.charAt(endPos - 1) == '\\') {
                    throw new InvalidAttributeMarker();
                }
                String attrName = template.substring(startPos + 1, endPos);
                String attrValue = this.getEntityHTMLRepresentation(attrName);
                if (attrValue != null) {
                    finalText.append(template.substring(chunkEnd, startPos));
                    finalText.append(this.substituteEntityKeywords(attrValue));
                    chunkEnd = startPos = endPos + 1;
                    continue;
                }
                ++startPos;
            }
        }
        catch (InvalidAttributeMarker invalidAttributeMarker) {
            // empty catch block
        }
        finalText.append(template.substring(chunkEnd));
        return finalText.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String getEntityHTMLRepresentation(String attrName) {
        attrValue = this.getIntrinsicContentProducer().getContent(this, attrName, null);
        if (attrValue != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            attrValue = attrValue instanceof ContentProducer != false ? ((ContentProducer)attrValue).getContent(this, attrName, attrValue) : ((defaultProducer = this.getContentProducer(attrValue.getClass())) != null ? defaultProducer.getContent(this, attrName, attrValue) : attrValue.toString());
lbl5:
            // 2 sources

            ** while (attrValue != null && !(attrValue instanceof String))
        }
lbl6:
        // 1 sources

        return (String)attrValue;
    }

    protected BufferedImage getImage() {
        if (this.fImageHolder.isAvailable()) {
            return (BufferedImage)this.fImageHolder.getResource();
        }
        return null;
    }

    protected void setImage(BufferedImage newImage) {
        this.fImageHolder.setResource(newImage);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        this.addPopupMenuItems(popupMenu);
        popupMenu.setLightWeightPopupEnabled(true);
        return popupMenu;
    }

    protected void addPopupMenuItems(JPopupMenu popupMenu) {
        ButtonGroup drawingPopupGroup = new ButtonGroup();
        JRadioButtonMenuItem rbOption = new JRadioButtonMenuItem(new AbstractAction("Direct drawing"){

            public void actionPerformed(ActionEvent event) {
                HTMLTextAreaFigure.this.setUseDirectDraw(true);
            }
        });
        drawingPopupGroup.add(rbOption);
        if (this.usesDirectDraw()) {
            drawingPopupGroup.setSelected(rbOption.getModel(), true);
        }
        popupMenu.add(rbOption);
        rbOption = new JRadioButtonMenuItem(new AbstractAction("Buffered drawing"){

            public void actionPerformed(ActionEvent event) {
                HTMLTextAreaFigure.this.setUseDirectDraw(false);
            }
        });
        drawingPopupGroup.add(rbOption);
        if (this.usesBufferedDraw()) {
            drawingPopupGroup.setSelected(rbOption.getModel(), true);
        }
        popupMenu.add(rbOption);
        popupMenu.addSeparator();
        drawingPopupGroup = new ButtonGroup();
        rbOption = new JRadioButtonMenuItem(new AbstractAction("Normal HTML"){

            public void actionPerformed(ActionEvent event) {
                HTMLTextAreaFigure.this.setRawHTML(false);
            }
        });
        drawingPopupGroup.add(rbOption);
        drawingPopupGroup.setSelected(rbOption.getModel(), true);
        popupMenu.add(rbOption);
        rbOption = new JRadioButtonMenuItem(new AbstractAction("Raw HTML"){

            public void actionPerformed(ActionEvent event) {
                HTMLTextAreaFigure.this.setRawHTML(true);
            }
        });
        drawingPopupGroup.add(rbOption);
        popupMenu.add(rbOption);
    }

    public boolean usesDirectDraw() {
        return this.fUseDirectDraw;
    }

    public void setUseDirectDraw(boolean newUseDirectDraw) {
        this.fUseDirectDraw = newUseDirectDraw;
        this.setAttribute(FigureAttributeConstant.POPUP_MENU, (Object)this.createPopupMenu());
        this.markSizeDirty();
    }

    public void setUseBufferedDraw(boolean newUseBufferedDraw) {
        this.setUseDirectDraw(!newUseBufferedDraw);
    }

    public boolean usesBufferedDraw() {
        return !this.usesDirectDraw();
    }

    protected void markImageDirty() {
        this.fImageHolder.dispose();
    }

    protected boolean isImageDirty() {
        return !this.fImageHolder.isAvailable();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setFrameFigure((Figure)dr.readStorable());
        this.setUseDirectDraw(dr.readBoolean());
        this.setRawHTML(dr.readBoolean());
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getFrameFigure());
        dw.writeBoolean(this.usesDirectDraw());
        dw.writeBoolean(this.isRawHTML());
    }

    public void setAttribute(FigureAttributeConstant name, Object value) {
        super.setAttribute(name, value);
        this.markImageDirty();
    }

    public boolean isRawHTML() {
        return this.fRawHTML;
    }

    public void setRawHTML(boolean newRawHTML) {
        this.fRawHTML = newRawHTML;
        this.setAttribute(FigureAttributeConstant.POPUP_MENU, (Object)this.createPopupMenu());
    }

    protected ContentProducer getIntrinsicContentProducer() {
        return this.fIntrinsicContentProducer;
    }

    public void setIntrinsicContentProducer(ContentProducer newIntrinsicContentProducer) {
        this.fIntrinsicContentProducer = newIntrinsicContentProducer;
    }

    public ContentProducer registerContentProducer(Class targetClass, ContentProducer producer) {
        return this.fContentProducers.registerContentProducer(targetClass, producer);
    }

    public void unregisterContentProducer(Class targetClass, ContentProducer producer) {
        this.fContentProducers.unregisterContentProducer(targetClass, producer);
    }

    protected ContentProducer getContentProducer(Class targetClass) {
        return this.fContentProducers.getContentProducer(targetClass);
    }

    public Polygon getPolygon() {
        Polygon polygon = new Polygon();
        AffineTransform at = AffineTransform.getScaleInstance(1.0, 1.0);
        FlatteningPathIterator pIter = new FlatteningPathIterator(this.getClippingShape().getPathIterator(at), 1.0);
        double[] coords = new double[6];
        while (!pIter.isDone()) {
            pIter.currentSegment(coords);
            polygon.addPoint((int)coords[0], (int)coords[1]);
            pIter.next();
        }
        return polygon;
    }

    protected Figure getFrameFigure() {
        return this.fFrameFigure;
    }

    public void setFrameFigure(Figure newFrameFigure) {
        if (this.fFrameFigure != null) {
            this.fFrameFigure.removeFigureChangeListener(this);
        }
        this.fFrameFigure = newFrameFigure;
        this.fFrameFigure.addFigureChangeListener(this);
    }

    protected Shape getClippingShape() {
        Figure frame = this.getFrameFigure();
        if (frame instanceof GeometricFigure) {
            return ((GeometricFigure)frame).getShape();
        }
        return frame.displayBox();
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureChanged(FigureChangeEvent e) {
        this.willChange();
        super.basicDisplayBox(e.getFigure().displayBox().getLocation(), Geom.corner(e.getFigure().displayBox()));
        this.changed();
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    public Figure getRepresentingFigure() {
        return this;
    }

    private class InvalidAttributeMarker
    extends Exception {
        private InvalidAttributeMarker() {
        }
    }
}

