/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.jhotdraw.contrib.html.ContentProducer;
import org.jhotdraw.contrib.html.URLContentProducer;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ContentProducerRegistry
implements Serializable,
Storable {
    private Hashtable fContentProducers = new Hashtable();
    private transient ContentProducerRegistry fParent;
    private static ContentProducerRegistry fDefaultRegistry = new ContentProducerRegistry(null);

    static {
        fDefaultRegistry.registerContentProducer(URL.class, new URLContentProducer());
    }

    public ContentProducerRegistry() {
        this.setParent(fDefaultRegistry);
    }

    public ContentProducerRegistry(ContentProducerRegistry parent) {
        this.setParent(parent);
    }

    public void setAutonomous() {
        this.setParent(null);
    }

    public boolean isAutonomous() {
        return this.getParent() == null;
    }

    public void setParent(ContentProducerRegistry newParent) {
        this.fParent = newParent;
    }

    public ContentProducerRegistry getParent() {
        return this.fParent;
    }

    public static ContentProducer registerDefaultContentProducer(Class targetClass, ContentProducer producer) {
        return fDefaultRegistry.registerContentProducer(targetClass, producer);
    }

    public static void unregisterDefaultContentProducer(Class targetClass, ContentProducer producer) {
        fDefaultRegistry.unregisterContentProducer(targetClass, producer);
    }

    public static ContentProducer getDefaultContentProducer(Class targetClass) {
        return fDefaultRegistry.getContentProducer(targetClass);
    }

    public static ContentProducer getExactDefaultContentProducer(Class targetClass) {
        return fDefaultRegistry.getExactContentProducer(targetClass);
    }

    public ContentProducer registerContentProducer(Class targetClass, ContentProducer producer) {
        ContentProducer previousProducer = this.getContentProducer(targetClass);
        this.fContentProducers.put(targetClass, producer);
        return previousProducer;
    }

    public void unregisterContentProducer(Class targetClass, ContentProducer producer) {
        ContentProducer currentProducer = this.getContentProducer(targetClass);
        if (currentProducer == producer) {
            this.fContentProducers.remove(targetClass);
        }
    }

    public ContentProducer getContentProducer(Class targetClass) {
        ContentProducer producer = this.getExactContentProducer(targetClass);
        if (producer != null) {
            return producer;
        }
        return this.getSuperClassContentProducer(targetClass, null);
    }

    public ContentProducer getExactContentProducer(Class targetClass) {
        ContentProducer producer = (ContentProducer)this.fContentProducers.get(targetClass);
        if (producer != null) {
            return producer;
        }
        if (!this.isAutonomous()) {
            return this.getParent().getExactContentProducer(targetClass);
        }
        return null;
    }

    protected ContentProducer getSuperClassContentProducer(Class targetClass, Class closestClass) {
        ContentProducer parentProducer;
        Map.Entry entry2 = null;
        Class entryClass = null;
        ContentProducer closestProducer = null;
        for (Map.Entry entry2 : this.fContentProducers.entrySet()) {
            entryClass = (Class)entry2.getKey();
            if (!entryClass.isAssignableFrom(targetClass) || closestClass == null || !closestClass.isAssignableFrom(entryClass)) continue;
            closestClass = entryClass;
            closestProducer = (ContentProducer)entry2.getValue();
        }
        if (!this.isAutonomous() && (parentProducer = this.getParent().getSuperClassContentProducer(targetClass, closestClass)) != null) {
            closestProducer = parentProducer;
        }
        return closestProducer;
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.fContentProducers.size());
        for (Map.Entry producerEntry : this.fContentProducers.entrySet()) {
            dw.writeString(((Class)producerEntry.getKey()).getName());
            dw.writeStorable((Storable)producerEntry.getKey());
        }
    }

    public void read(StorableInput dr) throws IOException {
        int prodCount = dr.readInt();
        int cnt = 0;
        while (cnt < prodCount) {
            String prodClass = dr.readString();
            ContentProducer producer = (ContentProducer)dr.readStorable();
            try {
                this.registerContentProducer(Class.forName(prodClass), producer);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++cnt;
        }
    }
}

