/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import org.jhotdraw.contrib.html.ContentProducerContext;
import org.jhotdraw.contrib.html.FigureDataContentProducer;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ColorContentProducer
extends FigureDataContentProducer
implements Serializable {
    private Color fColor = null;

    public ColorContentProducer() {
    }

    public ColorContentProducer(Color color) {
        this.setColor(color);
    }

    public Object getContent(ContentProducerContext context, String ctxAttrName, Object ctxAttrValue) {
        Color color = this.getColor() != null ? this.getColor() : (Color)ctxAttrValue;
        String colorCode = Integer.toHexString(color.getRGB());
        return "0x" + colorCode.substring(colorCode.length() - 6);
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    public Color getColor() {
        return this.fColor;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this.getColor() != null);
        if (this.getColor() != null) {
            dw.writeInt(this.getColor().getRGB());
        }
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        boolean hasColor = dr.readBoolean();
        if (hasColor) {
            this.setColor(new Color(dr.readInt()));
        } else {
            this.setColor(null);
        }
    }
}

