/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Component;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JComponent;
import org.jhotdraw.contrib.dnd.DNDFigures;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.DNDHelper;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class JHDDragSourceListener
implements DragSourceListener {
    private Undoable sourceUndoable;
    private Boolean autoscrollState;
    private DrawingEditor editor;

    public JHDDragSourceListener(DrawingEditor newEditor, DrawingView newView) {
        this.editor = newEditor;
    }

    protected DrawingEditor editor() {
        return this.editor;
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        Component c;
        DrawingView view = (DrawingView)((Object)dsde.getDragSourceContext().getComponent());
        JHDDragSourceListener.log("DragSourceDropEvent-dragDropEnd");
        if (dsde.getDropSuccess()) {
            if (dsde.getDropAction() == 2) {
                JHDDragSourceListener.log("DragSourceDropEvent-ACTION_MOVE");
                this.setSourceUndoActivity(this.createSourceUndoActivity(view));
                DNDFigures df = (DNDFigures)DNDHelper.processReceivedData(DNDFiguresTransferable.DNDFiguresFlavor, dsde.getDragSourceContext().getTransferable());
                this.getSourceUndoActivity().setAffectedFigures(df.getFigures());
                DeleteFromDrawingVisitor deleteVisitor = new DeleteFromDrawingVisitor(view.drawing());
                FigureEnumeration fe = this.getSourceUndoActivity().getAffectedFigures();
                while (fe.hasNextFigure()) {
                    fe.nextFigure().visit(deleteVisitor);
                }
                view.clearSelection();
                view.checkDamage();
                this.editor().getUndoManager().pushUndo(this.getSourceUndoActivity());
                this.editor().getUndoManager().clearRedos();
                this.editor().figureSelectionChanged(view);
            } else if (dsde.getDropAction() == 1) {
                JHDDragSourceListener.log("DragSourceDropEvent-ACTION_COPY");
            }
        }
        if (this.autoscrollState != null && JComponent.class.isInstance(c = dsde.getDragSourceContext().getComponent())) {
            JComponent jc = (JComponent)c;
            jc.setAutoscrolls(this.autoscrollState);
            this.autoscrollState = null;
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        Component c;
        JHDDragSourceListener.log("DragSourceDragEvent-dragEnter");
        if (this.autoscrollState == null && JComponent.class.isInstance(c = dsde.getDragSourceContext().getComponent())) {
            JComponent jc = (JComponent)c;
            this.autoscrollState = new Boolean(jc.getAutoscrolls());
            jc.setAutoscrolls(false);
        }
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        JHDDragSourceListener.log("DragSourceDragEvent-dropActionChanged");
    }

    protected Undoable createSourceUndoActivity(DrawingView drawingView) {
        return new RemoveUndoActivity(drawingView);
    }

    protected void setSourceUndoActivity(Undoable undoable) {
        this.sourceUndoable = undoable;
    }

    protected Undoable getSourceUndoActivity() {
        return this.sourceUndoable;
    }

    private static void log(String message) {
    }

    public static class RemoveUndoActivity
    extends UndoableAdapter {
        private boolean undone = false;

        public RemoveUndoActivity(DrawingView view) {
            super(view);
            JHDDragSourceListener.log("RemoveUndoActivity created " + view);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (this.isUndoable() && this.getAffectedFigures().hasNextFigure()) {
                JHDDragSourceListener.log("RemoveUndoActivity undo");
                this.getDrawingView().clearSelection();
                this.setAffectedFigures(this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false));
                this.undone = true;
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                JHDDragSourceListener.log("RemoveUndoActivity redo");
                DeleteFromDrawingVisitor deleteVisitor = new DeleteFromDrawingVisitor(this.getDrawingView().drawing());
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasNextFigure()) {
                    fe.nextFigure().visit(deleteVisitor);
                }
                this.getDrawingView().clearSelection();
                this.setAffectedFigures(deleteVisitor.getDeletedFigures());
                this.undone = false;
                return true;
            }
            return false;
        }

        public void release() {
            if (!this.undone) {
                FigureEnumeration fe = this.getAffectedFigures();
                while (fe.hasNextFigure()) {
                    Figure f = fe.nextFigure();
                    this.getDrawingView().drawing().remove(f);
                    f.release();
                }
            }
            this.setAffectedFigures(FigureEnumerator.getEmptyEnumeration());
        }
    }
}

