/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.JHDDragSourceListener;
import org.jhotdraw.contrib.dnd.JHDDropTargetListener;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;

public abstract class DNDHelper {
    public static DataFlavor ASCIIFlavor = new DataFlavor("text/plain; charset=ascii", "ASCII text");
    private DragGestureRecognizer dgr;
    private DragGestureListener dragGestureListener;
    private DropTarget dropTarget;
    private DragSourceListener dragSourceListener;
    private DropTargetListener dropTargetListener;
    private boolean isDragSource = false;
    private boolean isDropTarget = false;

    public DNDHelper(boolean newIsDragSource, boolean newIsDropTarget) {
        this.isDragSource = newIsDragSource;
        this.isDropTarget = newIsDropTarget;
    }

    public void initialize(DragGestureListener dgl) {
        if (this.isDragSource) {
            this.setDragGestureListener(dgl);
            this.setDragSourceListener(this.createDragSourceListener());
            this.setDragGestureRecognizer(this.createDragGestureRecognizer(this.getDragGestureListener()));
        }
        if (this.isDropTarget) {
            this.setDropTargetListener(this.createDropTargetListener());
            this.setDropTarget(this.createDropTarget());
        }
    }

    public void deinitialize() {
        if (this.getDragSourceListener() != null) {
            this.destroyDragGestreRecognizer();
            this.setDragSourceListener(null);
        }
        if (this.getDropTargetListener() != null) {
            this.setDropTarget(null);
            this.setDropTargetListener(null);
        }
    }

    protected abstract DrawingView view();

    protected abstract DrawingEditor editor();

    protected static Object processReceivedData(DataFlavor flavor, Transferable transferable) {
        Object receivedData = null;
        if (transferable == null) {
            return null;
        }
        try {
            if (flavor.equals(DataFlavor.stringFlavor)) {
                receivedData = transferable.getTransferData(DataFlavor.stringFlavor);
            } else if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                List aList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                File[] fList = new File[aList.size()];
                aList.toArray(fList);
                receivedData = fList;
            } else if (flavor.equals(ASCIIFlavor)) {
                int length;
                byte[] bytes;
                InputStream is = (InputStream)transferable.getTransferData(ASCIIFlavor);
                int n = is.read(bytes = new byte[length = is.available()]);
                if (n > 0) {
                    receivedData = new String(bytes, 0, n);
                }
            } else if (flavor.equals(DNDFiguresTransferable.DNDFiguresFlavor)) {
                receivedData = transferable.getTransferData(DNDFiguresTransferable.DNDFiguresFlavor);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (UnsupportedFlavorException ufe) {
            System.err.println(ufe);
        }
        catch (ClassCastException cce) {
            System.err.println(cce);
        }
        return receivedData;
    }

    protected int getDragSourceActions() {
        return 3;
    }

    protected int getDropTargetActions() {
        return 3;
    }

    protected void setDragGestureListener(DragGestureListener dragGestureListener) {
        this.dragGestureListener = dragGestureListener;
    }

    protected DragGestureListener getDragGestureListener() {
        return this.dragGestureListener;
    }

    protected void setDragGestureRecognizer(DragGestureRecognizer dragGestureRecognizer) {
        this.dgr = dragGestureRecognizer;
    }

    protected DragGestureRecognizer getDragGestureRecognizer() {
        return this.dgr;
    }

    protected void setDropTarget(DropTarget newDropTarget) {
        if (newDropTarget == null && this.dropTarget != null) {
            this.dropTarget.setComponent(null);
            this.dropTarget.removeDropTargetListener(this.getDropTargetListener());
        }
        this.dropTarget = newDropTarget;
    }

    protected DropTarget createDropTarget() {
        DropTarget dt = null;
        if (Component.class.isInstance(this.view())) {
            try {
                dt = new DropTarget((Component)((Object)this.view()), this.getDropTargetActions(), this.getDropTargetListener());
            }
            catch (NullPointerException npe) {
                System.err.println("View Failed to initialize to DND.");
                System.err.println("Container likely did not have peer before the DropTarget was added");
                System.err.println(npe);
                npe.printStackTrace();
            }
        }
        return dt;
    }

    protected DragGestureRecognizer createDragGestureRecognizer(DragGestureListener dgl) {
        DragGestureRecognizer aDgr = null;
        if (Component.class.isInstance(this.view())) {
            Component c = (Component)((Object)this.view());
            aDgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(c, this.getDragSourceActions(), dgl);
        }
        return aDgr;
    }

    protected void destroyDragGestreRecognizer() {
        if (this.getDragGestureRecognizer() != null) {
            this.getDragGestureRecognizer().removeDragGestureListener(this.getDragGestureListener());
            this.getDragGestureRecognizer().setComponent(null);
            this.setDragGestureRecognizer(null);
        }
    }

    protected void setDropTargetListener(DropTargetListener dropTargetListener) {
        this.dropTargetListener = dropTargetListener;
    }

    protected DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    protected DropTargetListener createDropTargetListener() {
        return new JHDDropTargetListener(this.editor(), this.view());
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceListener;
    }

    protected void setDragSourceListener(DragSourceListener dragSourceListener) {
        this.dragSourceListener = dragSourceListener;
    }

    protected DragSourceListener createDragSourceListener() {
        return new JHDDragSourceListener(this.editor(), this.view());
    }
}

