/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.jhotdraw.contrib.TriangleFigure;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Geom;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

class TriangleRotationHandle
extends AbstractHandle {
    private Point fOrigin;

    public TriangleRotationHandle(TriangleFigure owner) {
        super(owner);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.fOrigin = this.getOrigin();
        UndoActivity activity = (UndoActivity)this.createUndoActivity(view);
        this.setUndoActivity(activity);
        activity.setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        double rotation = ((TriangleFigure)this.owner()).getRotationAngle();
        activity.setRotationAngle(rotation);
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Point fCenter = this.owner().center();
        double angle = Math.atan2(this.fOrigin.y + y - anchorY - fCenter.y, this.fOrigin.x + x - anchorX - fCenter.x);
        ((TriangleFigure)this.owner()).rotate(angle);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.fOrigin = null;
    }

    public Point locate() {
        return this.getOrigin();
    }

    Point getOrigin() {
        Polygon p = ((TriangleFigure)this.owner()).getPolygon();
        Point first = new Point(p.xpoints[0], p.ypoints[0]);
        Point ctr = this.owner().center();
        double len = Geom.length(first.x, first.y, ctr.x, ctr.y);
        if (len == 0.0) {
            return new Point(first.x - 4, first.y + 4);
        }
        double u = 8.0 / len;
        if (u > 1.0) {
            return new Point((first.x * 3 + ctr.x) / 4, (first.y * 3 + ctr.y) / 4);
        }
        return new Point((int)((double)first.x * (1.0 - u) + (double)ctr.x * u), (int)((double)first.y * (1.0 - u) + (double)ctr.y * u));
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    protected Undoable createUndoActivity(DrawingView newView) {
        return new UndoActivity(newView);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private double myRotationAngle;

        public UndoActivity(DrawingView newView) {
            super(newView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            return this.resetRotationAngle();
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            return this.resetRotationAngle();
        }

        protected boolean resetRotationAngle() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasNextFigure()) {
                return false;
            }
            TriangleFigure figure = (TriangleFigure)fe.nextFigure();
            double backupAngle = figure.getRotationAngle();
            figure.willChange();
            figure.rotate(this.getRotationAngle());
            figure.changed();
            this.setRotationAngle(backupAngle);
            return true;
        }

        protected void setRotationAngle(double newRotationAngle) {
            this.myRotationAngle = newRotationAngle;
        }

        public double getRotationAngle() {
            return this.myRotationAngle;
        }
    }
}

