/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.contrib.Layoutable;
import org.jhotdraw.contrib.Layouter;
import org.jhotdraw.contrib.SimpleLayouter;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;

public class StandardLayouter
extends SimpleLayouter {
    public StandardLayouter() {
        this(null);
    }

    public StandardLayouter(Layoutable newLayoutable) {
        super(newLayoutable);
    }

    public Layouter create(Layoutable newLayoutable) {
        return new StandardLayouter(newLayoutable);
    }

    public Rectangle calculateLayout(Point origin, Point corner) {
        int maxWidth = Math.abs(corner.x - origin.x);
        int maxHeight = this.getInsets().top;
        FigureEnumeration fe = this.getLayoutable().figures();
        while (fe.hasNextFigure()) {
            Figure currentFigure = fe.nextFigure();
            Rectangle r = null;
            if (currentFigure instanceof Layoutable) {
                Layouter layoutStrategy = ((Layoutable)currentFigure).getLayouter();
                r = layoutStrategy.calculateLayout(new Point(0, 0), new Point(0, 0));
            } else {
                r = new Rectangle(currentFigure.displayBox().getBounds());
            }
            maxWidth = Math.max(maxWidth, r.width + this.getInsets().left + this.getInsets().right);
            maxHeight += r.height;
        }
        return new Rectangle(origin.x, origin.y, maxWidth, maxHeight += this.getInsets().bottom);
    }

    public Rectangle layout(Point origin, Point corner) {
        Rectangle r = this.calculateLayout(origin, corner);
        int maxHeight = this.getInsets().top;
        FigureEnumeration fe = this.getLayoutable().figures();
        while (fe.hasNextFigure()) {
            Figure currentFigure = fe.nextFigure();
            Point partOrigin = new Point(r.x + this.getInsets().left, r.y + maxHeight);
            Point partCorner = new Point(r.x + r.width - this.getInsets().right, r.y + maxHeight + currentFigure.displayBox().height);
            currentFigure.displayBox(partOrigin, partCorner);
            maxHeight += currentFigure.displayBox().height;
        }
        return new Rectangle(r.x, r.y, r.width, maxHeight + this.getInsets().bottom);
    }
}

