/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.DesktopEventService;
import org.jhotdraw.contrib.DesktopListener;
import org.jhotdraw.contrib.Helper;
import org.jhotdraw.framework.DrawingView;

public class SplitPaneDesktop
extends JSplitPane
implements Desktop {
    private DesktopEventService myDesktopEventService;

    public SplitPaneDesktop() {
        this.setDesktopEventService(this.createDesktopEventService());
        this.setAlignmentX(0.0f);
        this.setOneTouchExpandable(true);
        this.addPropertyChangeListener(this.createPropertyChangeListener());
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (SplitPaneDesktop.this.getRightComponent() != null) {
                    SplitPaneDesktop.this.getRightComponent().repaint();
                }
                if (SplitPaneDesktop.this.getLeftComponent() != null) {
                    SplitPaneDesktop.this.getLeftComponent().repaint();
                }
            }
        };
    }

    protected Component createContents(DrawingView dv, int location) {
        this.setRightComponent(this.createRightComponent(dv));
        this.setLeftComponent(this.createLeftComponent(dv));
        switch (location) {
            case 0: {
                return this.getLeftComponent();
            }
            case 1: {
                return this.getRightComponent();
            }
        }
        return null;
    }

    protected Component createRightComponent(DrawingView dv) {
        JScrollPane sp = new JScrollPane((Component)((Object)dv));
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(32);
        sp.setAlignmentX(0.0f);
        return sp;
    }

    protected Component createLeftComponent(DrawingView dv) {
        return new JScrollPane(new JList());
    }

    public DrawingView getActiveDrawingView() {
        return this.getDesktopEventService().getActiveDrawingView();
    }

    public void addToDesktop(DrawingView dv, int location) {
        this.createContents(dv, 0);
        this.setDividerLocation(this.getInitDividerLocation());
    }

    protected int getInitDividerLocation() {
        return 150;
    }

    public void removeFromDesktop(DrawingView dv, int location) {
        Component[] comps = this.getContainer().getComponents();
        int x = 0;
        while (x < comps.length) {
            if (dv == Helper.getDrawingView(comps[x])) {
                this.getContainer().remove(comps[x]);
                break;
            }
            ++x;
        }
    }

    public void removeAllFromDesktop(int location) {
        this.getContainer().removeAll();
    }

    public DrawingView[] getAllFromDesktop(int location) {
        return this.getDesktopEventService().getDrawingViews(this.getComponents());
    }

    public void addDesktopListener(DesktopListener dpl) {
        this.getDesktopEventService().addDesktopListener(dpl);
    }

    public void removeDesktopListener(DesktopListener dpl) {
        this.getDesktopEventService().removeDesktopListener(dpl);
    }

    private Container getContainer() {
        return this;
    }

    protected DesktopEventService getDesktopEventService() {
        return this.myDesktopEventService;
    }

    private void setDesktopEventService(DesktopEventService newDesktopEventService) {
        this.myDesktopEventService = newDesktopEventService;
    }

    protected DesktopEventService createDesktopEventService() {
        return new DesktopEventService(this, this.getContainer());
    }

    public void updateTitle(String newDrawingTitle) {
        this.setName(newDrawingTitle);
    }
}

