/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import javax.swing.JToolBar;
import org.jhotdraw.application.DrawApplication;
import org.jhotdraw.contrib.Desktop;
import org.jhotdraw.contrib.MDIDesktopPane;
import org.jhotdraw.contrib.dnd.DragNDropTool;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.standard.NullDrawingView;
import org.jhotdraw.standard.ToolButton;

public class MDI_DrawApplication
extends DrawApplication {
    public MDI_DrawApplication() {
        this("JHotDraw");
    }

    public MDI_DrawApplication(String title) {
        super(title);
    }

    protected DrawApplication createApplication() {
        return new MDI_DrawApplication();
    }

    protected void createTools(JToolBar palette) {
        super.createTools(palette);
        DragNDropTool tool = new DragNDropTool(this);
        ToolButton tb = this.createToolButton("/org/jhotdraw/images/SEL", "Drag N Drop Tool", tool);
        palette.add(tb);
    }

    public void promptNew() {
        this.newWindow(this.createDrawing());
    }

    public void newWindow(Drawing newDrawing) {
        DrawingView newView = this.createDrawingView(newDrawing);
        this.getDesktop().addToDesktop(newView, 0);
        this.toolDone();
    }

    protected DrawingView createInitialDrawingView() {
        return NullDrawingView.getManagedDrawingView(this);
    }

    public void newView() {
        if (!this.view().isInteractive()) {
            return;
        }
        this.newWindow(this.view().drawing());
        String copyTitle = this.getDrawingTitle();
        if (copyTitle != null) {
            this.setDrawingTitle(copyTitle);
        } else {
            this.setDrawingTitle(this.getDefaultDrawingTitle());
        }
    }

    protected Desktop createDesktop() {
        return new MDIDesktopPane(this);
    }

    public DrawingView[] views() {
        return this.getDesktop().getAllFromDesktop(0);
    }

    public String getDefaultDrawingTitle() {
        return String.valueOf(super.getDefaultDrawingTitle()) + this.views().length;
    }

    protected void setDrawingTitle(String drawingTitle) {
        this.getDesktop().updateTitle(drawingTitle);
    }
}

