/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Painter;

public class GridPainter
implements Painter {
    private int myHorizontalSeparation;
    private int myVerticalSeparation;
    private Color myColor;

    public GridPainter(int horizontalSeparation, int verticalSeparation) {
        this.setHorizontalSeparation(horizontalSeparation);
        this.setVerticalSeparation(verticalSeparation);
        this.setColor(Color.black);
    }

    public GridPainter(int newSeparation) {
        this(newSeparation, newSeparation);
    }

    public int getHorizontalSeparation() {
        return this.myHorizontalSeparation;
    }

    public void setHorizontalSeparation(int newHorizontalSeparation) {
        this.myHorizontalSeparation = newHorizontalSeparation;
    }

    public int getVerticalSeparation() {
        return this.myVerticalSeparation;
    }

    public void setVerticalSeparation(int newVerticalSeparation) {
        this.myVerticalSeparation = newVerticalSeparation;
    }

    public void draw(Graphics g, DrawingView view) {
        g.setColor(this.getColor());
        Dimension size = view.getSize();
        int width = size.width;
        int height = size.height;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                g.drawRect(x, y, 0, 0);
                y += this.getVerticalSeparation();
            }
            x += this.getHorizontalSeparation();
        }
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color newColor) {
        this.myColor = newColor;
    }
}

